/***********************************************************************
 statusServer
 ***********************************************************************/

#include <ctime>
#include <iostream>

#include "StatusServer.hh"
#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"
#include "SocketPorts.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"


using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  StatusServer server;
  const BufferStatus* const b(server.send());

  if(b==0) {
    cerr << argv[0] << " " << ctime(&(t=time(0)));
    cerr << " BufferStatus pointer is null" << endl;
    
  } else {
    try {
      DuplexSocket dSock(STATUSPORT);
      cout << argv[0] << " " << ctime(&(t=time(0)));
      cout << " Server socket initialised" << endl;
      dSock.print(cout);
      
      while(!b->shutDown()) {
	cout << argv[0] << " " << ctime(&(t=time(0)));
	b->print(cout);
	dSock.send(server.send(),1);
	sleep(1);
      }
      cout << argv[0] << " " << ctime(&(t=time(0)));
      cout << " Shutdown command seen" << endl;

    } catch(SocketException &e) {
      cout << argv[0] << " " << ctime(&(t=time(0)));
      cout << " Exception was caught: " << e.description() << endl;
    }
  }  
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
