#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketProducer.hh"
#include "DioMultiConsumer.hh"
#include "DioThread.hh"
#include "OnlWriterDmy.hh"
#include "OnlWriterAsc.hh"

using namespace std;

int main() {
  DioSocketProducer<RcdArena> p0(12340);
  DioSocketProducer<RcdArena> p1(12341);
  DioSocketProducer<RcdArena> p2(12342);
  DioSocketProducer<RcdArena> p3(12343);
  DioMultiConsumer<RcdArena> m(4);

  // Choose a writer

//OnlWriterAsc w;
  OnlWriterDmy w;


  DioThread<RcdArena> t0(p0,m.consumer(0));
  t0.create();
  DioThread<RcdArena> t1(p1,m.consumer(1));
  t1.create();
  DioThread<RcdArena> t2(p2,m.consumer(2));
  t2.create();
  DioThread<RcdArena> t3(p3,m.consumer(3));
  t3.create();
  DioThread<RcdArena> t4(m,w);
  t4.create();

  t0.join();
  t1.join();
  t2.join();
  t3.join();
  t4.join();

  return 0;
}
