#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream>

#include "UtlArguments.hh"
#include "DaqRunControl.hh"
#include "ShmObject.hh"

using namespace std;

int main(int argc, const char **argv) {

  unsigned eTime(CALICE_DAQ_TIME);
  cout << argv[0] << " compiled at " << ctime((const time_t*)&eTime) << endl;
 
  UtlArguments argh(argc,argv);
  const unsigned vnum(argh.lastArgument(999999)); 
   
  //if(argh.help()) return 0;
   
  ShmObject<DaqRunControl> shmRunControl(DaqRunControl::shmKey);
  DaqRunControl *p(shmRunControl.payload());
  if(p==0) return 1;

  if(vnum>=DaqRunControl::endOfCommandEnum) {
    p->print(cout);
    return 0;
  }

  p->command((DaqRunControl::Command)vnum);
  p->print(cout);
  
  return 0;
}
