#include <signal.h>
#include <sys/types.h>
#include <unistd.h>

#include <iostream>

#include "ShmObject.hh"
#include "DaqRunControl.hh"

using namespace std;

bool continueJob=true;

void signalHandler(int signal) {
  std::cerr << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}

int main(int argc, char *argv[]) {
  signal(SIGINT,signalHandler);
  signal(SIGTERM,signalHandler);

  ShmObject<DaqRunControl> shmRunControl(DaqRunControl::shmKey);
  DaqRunControl *p(shmRunControl.payload());

  if(p==0) return 1;
  if(!p->commandRegister()) return 2;
  if(!p->statusRegister()) return 3;

  unsigned nSleep(10);

  const RcdCount &count(p->count());

  vector<time_t> vt;
  vector<unsigned> vn;
  vt.push_back(time(0));
  vn.push_back(count.count(RcdHeader::events));

  while(continueJob) {
    p->print(cout);

    vt.push_back(time(0));
    vn.push_back(count.count(RcdHeader::events));
    cout << "Increment of events " << setw(6) << vn[vn.size()-1]-vn[0] << endl;
    cout << "Increment of time   " << setw(6) << vt[vt.size()-1]-vt[0] << endl;

    sleep(nSleep);
  }
  
  if(!p->unregister()) return 4;
  return 0;
}
