#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CercVmeDevice.hh"
#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, char *argv[]) {

  unsigned numberOfCercs(1);
  if(argc>1) numberOfCercs=argc-1;

  unsigned *addressOfCerc(new unsigned[numberOfCercs]);
  if(argc==1) {
    addressOfCerc[0]=7;
  } else {
    for(unsigned i(0);i<numberOfCercs;i++) {
      unsigned slot;
      sscanf(argv[i+1],"%u",&slot);
      addressOfCerc[i]=slot;
    }
  }

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCercs << endl;
    CercVmeDevice *CercVMECard[20];
    for(unsigned i(0);i<numberOfCercs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCerc[i] << dec << endl;
      CercVMECard[i]=new CercVmeDevice(addressTable,busAdapter,addressOfCerc[i]);
    }

    //CercVmeDevice CercVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    bool loop = true;
    string item, name;
    unsigned long option, value, nCard;
    vector<string> names;

    nCard=0;

    cout << "sizeof(unsigned) = " << sizeof(unsigned) << endl;
    cout << "sizeof(unsigned long) = " << sizeof(unsigned long) << endl;

    // Here the interactive loop for the user interaction starts.
    // All this is very bad spaghetti code and should not be taken
    // serious. It just shows how to use some of the HAL components.

    signal(SIGINT,SIG_IGN);

    RcdArena arena;
    SlwCercReadout slw(*CercVMECard[nCard]);

    arena.deleteData();
    arena.updateRecordTime();
    arena.recordType(SubHeader::startUp);

    SubInserter inserter(arena);

    SlwCercLm82StartupData *b(inserter.insert<SlwCercLm82StartupData>());
    b->crateNumber(0);
    b->slotNumber(7);
    b->componentNumber(CercLocationData::vme);
    b->manufacturerId(1);
    b->steppingCode(3);
    b->configuration(0x28);
    b->criticalLimit(50);
    b->localLimit(40);
    b->remoteLimit(40);

    SlwCercAdm1025StartupData *a(inserter.insert<SlwCercAdm1025StartupData>());
    a->crateNumber(0);
    a->slotNumber(7);
    a->componentNumber(CercLocationData::vme);
    a->manufacturerId(0x41);
    a->steppingCode(0x2a);
    a->vid(0x03);
    a->vid4(0x80);
    a->test(0);
    a->offset(1);
    a->configuration(0x01);
    a->localHighLimit(40);
    a->localLowLimit(10);
    a->remoteHighLimit(-126);
    a->remoteLowLimit(-128);

    SlwCercAdm1025Voltages v;

    v.dVoltage(SlwCercAdm1025Voltages::v25,1.1*1.8);
    v.dVoltage(SlwCercAdm1025Voltages::vccp,1.1*1.5);
    v.dVoltage(SlwCercAdm1025Voltages::v33,1.1*3.3);
    v.dVoltage(SlwCercAdm1025Voltages::v50,1.1*5.0);
    v.dVoltage(SlwCercAdm1025Voltages::v120,1.1*12.0);
    v.dVoltage(SlwCercAdm1025Voltages::vcc,1.1*3.3);
    a->voltageHighLimits(v);

    v.dVoltage(SlwCercAdm1025Voltages::v25,0.9*1.8);
    v.dVoltage(SlwCercAdm1025Voltages::vccp,0.9*1.5);
    v.dVoltage(SlwCercAdm1025Voltages::v33,0.9*3.3);
    v.dVoltage(SlwCercAdm1025Voltages::v50,0.9*5.0);
    v.dVoltage(SlwCercAdm1025Voltages::v120,0.9*12.0);
    v.dVoltage(SlwCercAdm1025Voltages::vcc,0.9*3.3);
    a->voltageLowLimits(v);

    slw.readout(arena);

    ostringstream oss;
    oss << "slw/Slw" << arena.recordTime().seconds();

    signal(SIGINT,SIG_IGN);

    RcdWriterAsc writer;
    writer.open(oss.str());
    writer.write(&arena);

    signal(SIGINT,signalHandler);

    while(continueJob) {
      arena.deleteData();
      arena.updateRecordTime();
      arena.recordType(SubHeader::slowControl);

      slw.readout(arena);
      writer.write(&arena);

      sleep(10);
    }

    signal(SIGINT,SIG_IGN);

    arena.deleteData();
    arena.updateRecordTime();
    arena.recordType(SubHeader::shutdown);

    slw.readout(arena);
    writer.write(&arena);
    writer.close();

  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << endl;
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  cout << "This is the end, my friend..." << endl;
  return 0;
}
