#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "UtlArguments.hh"
#include "BmlLc1176VmeDevice.hh"
#include "BmlLc1176Readout.hh"
#include "RcdArena.hh"


using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "online/hal/Lc1176VmeAddress.hal"
#define SEQUENCE_SETTINGS "Sequences.dat"


bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
	    << signal << std::endl;
  continueJob=false;
}

int main(int argc, const char **argv) {
  try{

  UtlArguments argh(argc,argv);
  //argh.print(cout);

  const bool doCheck(argh.option('c',"Run data check"));
  const bool doHistograms(argh.option('s',"Display histograms"));
  const bool doGraphics(argh.option('g',"Display graphics"));
  const bool useIntTrigger(argh.option('i',"Internal trigger selection"));

  const unsigned printLevel(argh.optionArgument('p',5,"Print level"));
  const unsigned feMask(argh.optionArgument('f',0xff,"FE mask"));
  const unsigned nEvents(argh.optionArgument('n',10,"Number of events between updates"));

  std::string logFile(argh.optionArgument('l',"log/msg.log","RS232 message log file"));

  if(argh.help()) return 0;

  if(doCheck) cout << "Data check selected" << endl;
  else           cout << "Data check not selected" << endl;
  if(doHistograms) cout << "Histograms display selected" << endl;
  else           cout << "Histograms display not selected" << endl;
  if(doGraphics) cout << "Graphics display selected" << endl;
  else           cout << "Graphics display not selected" << endl;
  if(useIntTrigger) cout << "Internal trigger selected" << endl;
  else              cout << "External trigger selected" << endl;

  cout << "Print level set to " << printLevel << endl;
  cout << "FE mask set to " << printHex((unsigned char)feMask) << endl;
  cout << "Number of events set to " << nEvents << endl;

  SBS620x86LinuxBusAdapter busAdapter(0);
  VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
  VMEAddressTable addressTable( "Test address table", addressTableReader );

  //BmlLc1176VmeDevice dev(addressTable,busAdapter); // Imperial; default = 0x25
  BmlLc1176VmeDevice dev(addressTable,busAdapter,0x98); // DESY
  assert(dev.alive());

  BmlLc1176Readout ro(0,0x98);
  ro.printLevel(5);

  RcdArena arena;
  SubInserter inserter(arena);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::runStart);
  ro.record(arena);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::configurationStart);

  BmlLc1176ConfigurationData *b(inserter.insert<BmlLc1176ConfigurationData>());
  assert(dev.readConfigurationData(*b));

  //unsigned char test(0xfa);
  unsigned char test(0xfc);
  //unsigned char test(0x00);

  //b->csr(0xc700+test);
  b->csr(0x8600+test);
  b->print(std::cout) << std::endl;
  ro.record(arena);

  /*
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  dev.write("CSRd",test+1);
  */
  dev.softTrigger();

  sleep(1);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::event);
  ro.record(arena);

  dev.softTrigger();

  sleep(1);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::event);
  ro.record(arena);


  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::configurationEnd);
  ro.record(arena);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::runEnd);
  ro.record(arena);



  //dev.testMode();


} catch ( HardwareAccessException& e ) {
  cout << "*** Exception occurred : " << endl;
  cout << e.what() << " I Made This" << endl;
    
} catch ( exception e ) {
  cout << "*** Unknown exception occurred" << endl;
}


}
