#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CercVmeDevice.hh"
#include "CercVmeSerialCommandBit.hh"
#include "CercVmeSerialCommandWord.hh"
#include "CercVmeSerialCommandEventTag.hh"
#include "CercVmeSerialCommandLoadTick.hh"
#include "CercVmeSerialCommandFeConfigurationData.hh"
#include "CercVmeSerialCommandFeFakeEventData.hh"
#include "CercVmeSerialCommandFeMode.hh"
#include "CercVmeSerialCommandFeScopeLength.hh"

#include "CercVmeSerialHeaderFeSoftwareReset.hh"
#include "CercVmeSerialHeaderBeSoftwareReset.hh"
#include "CercVmeSerialHeaderBeSoftwareTrigger.hh"
#include "CercVmeSerialHeaderSoftwareTrigger.hh"
#include "CercVmeSerialHeaderFeSoftwareTrigger.hh"
#include "FedBeConfiguration.hh"
#include "FedFeConfiguration.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"


int main(int argc, char *argv[]) {

  unsigned numberOfCercs(1);
  if(argc>1) numberOfCercs=argc-1;

  unsigned *addressOfCerc(new unsigned[numberOfCercs]);
  if(argc==1) {
    addressOfCerc[0]=7;
  } else {
    for(unsigned i(0);i<numberOfCercs;i++) {
      unsigned slot;
      sscanf(argv[i+1],"%u",&slot);
      addressOfCerc[i]=slot;
    }
  }

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCercs << endl;
    CercVmeDevice *CercVMECard[20];
    for(unsigned i(0);i<numberOfCercs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCerc[i] << dec << endl;
      CercVMECard[i]=new CercVmeDevice(addressTable,busAdapter,addressOfCerc[i]);
    }

    //CercVmeDevice CercVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    bool loop = true;
    string item, name;
    unsigned long option, value, nCard;
    vector<string> names;

    nCard=0;

    cout << "sizeof(unsigned) = " << sizeof(unsigned) << endl;
    cout << "sizeof(unsigned long) = " << sizeof(unsigned long) << endl;

    // Here the interactive loop for the user interaction starts.
    // All this is very bad spaghetti code and should not be taken
    // serious. It just shows how to use some of the HAL components.

    while ( loop ) {
      cout << endl;
      cout << "0) end the program" << endl;
      cout << "1) write to item" << endl; 
      cout << "2) read from item" << endl;
      /*
      cout << "3) register a new sequence" << endl;
      cout << "4) excecute a sequence (after rescan)" << endl;
      cout << "5) delete a sequence" << endl;
      */
      cout << "3) print address table " << endl;
      cout << "4) set board number " << endl;
      cout << "5) reset board " << endl;
      cout << "6) print status " << endl;
      cout << "7) CERC FE configuration " << endl;
      cout << "8) FED BE configuration " << endl;
      cout << "9) FED FE configuration " << endl;
      cout << "10) Fire software trigger " << endl;
      cout << "11) Read vlink " << endl;
      cout << "12) Load fake event " << endl;
      cout << "13) BE/FE LM82 " << endl;
      cout << "14) VME LM82 " << endl;
      cout << "15) VME ADM1025 " << endl;
      cout << "16) DevBoard triggers " << endl;
      cout << "Enter option : ";
      std::cin >> option;

      switch (option) {
      case 0:
        loop = false;
        break;
      case 1:
        // if the item is defined readable in the addressmap than the address 
        // corresponding to the item is first read and only the bits belonging
        // to the item are changed. The obtained word is then written back.
        cout << "Enter item : ";
        cin >> item;
        cout << "Enter value (hex) : ";
        cin >> hex >> value >> dec;
        CercVMECard[nCard]->write( item, value );
        break;
      case 2:
        cout << "Enter item : ";
        cin >> item;
        CercVMECard[nCard]->read( item, &value );
        cout << "result : " << hex << setfill('0') << setw(8) << value << endl;
        break;

	/*
      case 3:
        cout << "Filename of new sequence : ";
        cin >> name;
        try {
          sequencer.registerSequence( name );
        } catch ( HardwareAccessException& e ) {
          cout << e.what() << endl;
        }
        break;
      case 4:
        names.clear();
        names = sequencer.getNameVector();
        cout << endl;
        if ( names.size() == 0 ) {
          cout << "There are no sequences registered!" << endl;
          break;
        }
        for( ic=0; ic < names.size(); ic++ ) {
          cout << "   " << (ic+1) << ") " << names[ic] << endl;
        }
        cout << "Enter Number : ";
        cin >> option;
        // the sequence is rescaned in case the user has changed 
        // it in the meanwhile in an editor. This is useful in 
        // the debugging phase. You do not need to restart the 
        // program. 
        if ( option > 0 && option <= names.size() ) {
          sequencer.rescan( names[option-1] );
          sequencer.run( names[option-1], *CercVMECard[nCard]);
        } else {
          cout << "Invalid number !" << endl;
        }
        break;
      case 5:
        cout << "Filename of sequence to be deleted : ";
        cin >> name;
        try {
          sequencer.deleteSequence( name );
        } catch ( HardwareAccessException& e ) {
          cout << e.what() << endl;
        }
        break;
	*/

      case 3:
        addressTable.print();
        break;
      case 4:
        cout << "Board number [0-" << numberOfCercs-1 << "]: ";
        cin >> nCard;
	if(nCard>numberOfCercs-1) nCard=0;
        cout << "Board number set to " << nCard << endl;
        break;
      case 5: {
	CercVMECard[nCard]->reset();
	CercVmeSerialHeaderBeSoftwareReset berst;
	//CercVMECard[nCard]->serialWrite(&berst);
	CercVmeSerialHeaderFeSoftwareReset ferst;
	//CercVMECard[nCard]->serialWrite(&ferst);
      } break;
      case 6:
	cout << endl;
	CercVMECard[nCard]->print(cout);
        break;
      case 7: {
	cout << endl << "*** Read, write CercVmeSerialCommandFeConfigurationData" << endl;

	CercFeConfigurationData yyy[8];
	CercFeFakeEventData fke[8];

	for(unsigned i(0);i<8;i++) {
	  yyy[i].vfeSrinStop(i);
	  yyy[i].fakeEventEnable(false);
	  //yyy[i].fakeEventLength(sizeof(CercFeFakeEventData)/4);
	  yyy[i].fakeEventLength(sizeof(CercFeFakeEventData)/8);
	  yyy[i].print(cout);
	  
	  CercVmeSerialHeader::Target t;
	  t=(CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);

	  CercVmeSerialCommandFeConfigurationData xxx(t);

	  CercVMECard[nCard]->serialRead(&xxx);
	  xxx.print(cout);
	  xxx.payload()->print(cout);
	  
	  *(xxx.payload())=yyy[i];
	  CercVMECard[nCard]->serialWrite(&xxx);

	  //	  if(yyy[i].fakeEventEnable()) {
	    fke[i].print(cout,"===>>>   ");

	    //	    for(unsigned i(0);i<8;i++) {
	    //	      CercVmeSerialHeader::Target t=
	    //	(CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);	  
	      
	    cout << endl << endl << "Loading fake event for FE" << i << endl;
	    CercVmeSerialCommandFeFakeEventData xxxa(t);
	    *(xxxa.payload())=fke[i];
	    xxxa.print(cout);
	    xxxa.payload()->print(cout);
	    CercVMECard[nCard]->serialWrite(&xxxa);
	    //	    }
	    //	  }
	}

	cout << endl 
	     << "*** Readback CercVmeSerialCommandFeConfigurationData"
	     << endl;

	bool okay(true);
	for(unsigned i(0);i<8;i++) {
	  CercVmeSerialHeader::Target t;
	  t=(CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);

	  CercVmeSerialCommandFeConfigurationData xxx(t);

	  CercVMECard[nCard]->serialRead(&xxx);
	  xxx.print(cout);
	  xxx.payload()->print(cout);

	  if(*(xxx.payload())!=yyy[i]) {
	    cout << endl << endl 
		 <<"Read back FE" << i << " data not equal to original"
		 << endl << endl << endl;
	    okay=false;
	  }

	  //	  if(yyy[i].fakeEventEnable()) {
	    CercVmeSerialCommandFeFakeEventData zzz(t);
	    CercVMECard[nCard]->serialRead(&zzz);
	    zzz.print(cout);
	    zzz.payload()->print(cout);

	    if(*(zzz.payload())!=fke[i]) {
	      cout << endl << endl 
		   <<"Read back FE" << i << " fake event not equal to original"
		   << endl << endl << endl;
	      okay=false;
	    }
	    //	  }
	}

	if(okay) {
	  cout << endl << endl 
	       <<"Read back OK"
	       << endl << endl << endl;
	} else {
	  cout << endl << endl 
	       <<"Read back NOT OK"
	       << endl << endl << endl;
	}


	for(unsigned i(0);i<8;i++) {
	  CercVmeSerialHeader::Target t;
	  t=(CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);

	  yyy[i].fakeEventEnable(true);
	  CercVmeSerialCommandFeConfigurationData xxxb(t);
	  *(xxxb.payload())=yyy[i];
	  CercVMECard[nCard]->serialWrite(&xxxb);

	  CercVmeSerialCommandWord load(t,CercVmeSerialHeader::feMode);
	  CercVMECard[nCard]->serialWrite(&load);
	}

      } break;
      case 8: {
	cout << endl << endl << "Configuring BE" << endl;
	FedBeConfiguration fed;	
	CercVMECard[nCard]->serialReadVector(fed.readVector());
	fed.print(cout);

	fed.mode(1);
	fed.test(4);
	fed.fedId(0xcec);
	fed.print(cout);
	CercVMECard[nCard]->serialWriteVector(fed.writeVector());
	CercVMECard[nCard]->serialReadVector(fed.readVector());
	fed.print(cout);
      } break;
      case 9: {
	for(unsigned i(0);i<8;i++) {
	  cout << endl << endl << "Configuring FE" << i << endl;
	  CercVmeSerialHeader::Target t=
	    (CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);	  

	  FedFeConfiguration fed(t);
	  CercVMECard[nCard]->serialReadVector(fed.readVector());
	  fed.print(cout);
	  
	  fed.mode(5);
	  fed.scopeLength(24);
	  fed.print(cout);
	  CercVMECard[nCard]->serialWriteVector(fed.writeVector());
	  CercVMECard[nCard]->serialReadVector(fed.readVector());
	  fed.print(cout);
	}
      } break;
      case 10: {
	CercVmeSerialHeaderBeSoftwareTrigger trg;
	CercVMECard[nCard]->serialWrite(&trg);

	sleep(1);

	FedBeConfiguration fedBe;	
	FedFeConfiguration fedFe(CercVmeSerialHeader::fe0);	

	CercVMECard[nCard]->serialReadVector(fedBe.readVector());
	fedBe.print(cout);
	//CercVMECard[nCard]->serialReadVector(fedFe.readVector());
	//fedFe.print(cout);

      } break;
      case 11: {
	unsigned array[128*1024];
	unsigned n(CercVMECard[nCard]->vlinkRead(array,true));

	ofstream fout("vlink.dat");

	cout << "Number of words = " << n << endl;	
	  cout << "array[0] = " << array[0] 
	       << " = 0x" << hex << array[0] << dec << endl;
	for(unsigned i(0);i<n;i++) {
	  cout << "array[" << i << "] = " << array[i] 
	       << " = 0x" << hex << array[i] << dec << endl;

	  fout << i << '\t' << array[i] << endl;
	}
	
	/*
	n=CercVMECard[nCard]->vlinkRead(array);

	cout << "Number of words = " << n << endl;
	for(unsigned i(0);i<n;i++) {
	  cout << "array[" << i << "] = " << array[i] 
	       << " = 0x" << hex << array[i] << dec << endl;
	}
	*/	

      } break;
      case 12: {	
	CercFeFakeEventData fe;
	fe.print(cout,"===>>>   ");

	for(unsigned i(0);i<8;i++) {
	  cout << endl << endl << "Loading fake event for FE" << i << endl;
	  CercVmeSerialHeader::Target t=
	    (CercVmeSerialHeader::Target)(i+CercVmeSerialHeader::fe0);	  

	  CercVmeSerialCommandFeFakeEventData xxx(t);
	  *(xxx.payload())=fe;
	  xxx.print(cout);
	  xxx.payload()->print(cout);
	  CercVMECard[nCard]->serialWrite(&xxx);
	  //	CercVMECard[nCard]->serialRead(&xxx);
	}

      } break;
      case 13: {
	//LM82
	cout << "Enter component number (0-7 = FE, 8 = BE): ";

	//CercLocationData::CercComponent c;
	unsigned c;
	cin >> c;

	SlwCercLm82StartupData d(0,7,c);
	CercVMECard[nCard]->readLm82Startup(d);
	cout << "Original LM82 startup data" << endl;
	d.print(cout);

	cout << endl << "Writing LM82 startup data" << endl;
	d.criticalLimit(50);
	d.localLimit(40);
	d.remoteLimit(41);
	d.configuration(0x28);

	if(c!=8) {
	  d.criticalLimit(51);
	  d.localLimit(42);
	  d.remoteLimit(43);
	}

	d.print(cout);

	CercVMECard[nCard]->writeLm82Startup(d);



	cout << endl << "Read back LM82 startup data" << endl;

	SlwCercLm82StartupData d2(0,7,c);

	CercVMECard[nCard]->readLm82Startup(d2);

	SlwCercLm82SlowControlsData s(0,7,c);
	CercVMECard[nCard]->readLm82SlowControls(s);

	d2.print(cout);
	cout << endl << "Read back LM82 slow controls data" << endl;
	s.print(cout);

	/*
        CercVmeSerialCommandBits<17> control(CercVmeSerialHeader::be ,CercVmeSerialHeader::designator12);
        CercVmeSerialCommandBits<16> status( CercVmeSerialHeader::be ,CercVmeSerialHeader::designator25);
	//CercVmeSerialCommandBits<17> control(CercVmeSerialHeader::fe0,CercVmeSerialHeader::designator05);
	//CercVmeSerialCommandBits<16> status( CercVmeSerialHeader::fe0,CercVmeSerialHeader::designator27);
	unsigned char add(0),reg;

	reg=0x0b;
	add=0x7b;
	control.bits((reg<<8) | add);
	CercVMECard[nCard]->serialWrite(&control);
	cout << "Trying " << printHex(control.bits(),false)
	     << ", reply 0" << endl;
	
	reg=0x0d;
	add=0x7d;
	control.bits((reg<<8) | add);
	CercVMECard[nCard]->serialWrite(&control);
	cout << "Trying " << printHex(control.bits(),false)
	     << ", reply 0" << endl;
	
	reg=0x09;
	add=0x28;
	control.bits((reg<<8) | add);
	CercVMECard[nCard]->serialWrite(&control);
	cout << "Trying " << printHex(control.bits(),false)
	     << ", reply 0" << endl;

	reg=0x5a;
	add=0x7a;
	control.bits((reg<<8) | add);
	CercVMECard[nCard]->serialWrite(&control);
	cout << "Trying " << printHex(control.bits(),false)
	     << ", reply 0" << endl;
	*/
	/*
	add=0;
	*/
	
	/*
	for(unsigned i(9);i<10;i++) {
	  if(i==0) add=0x18;
	  if(i==1) add=0x19;
	  if(i==2) add=0x1a;
	  if(i==3) add=0x29;
	  if(i==4) add=0x2a;
	  if(i==5) add=0x2b;
	  if(i==6) add=0x4c;
	  if(i==7) add=0x4d;
	  if(i==8) add=0x4e;
	  if(i==9) add=0x00;
	*/
	/*
	  for(unsigned j(0);j<20;j++) {
	    if(j==0) reg=0x00;
	    if(j==1) reg=0x01;
	    if(j==2) reg=0x02;
	    if(j==3) reg=0x03;
	    if(j==4) reg=0x05;
	    if(j==5) reg=0x07;
	    if(j==6) reg=0x42;
	    if(j==7) reg=0xfe;
	    if(j==8) reg=0xff;
	    if(j>=9) reg=j%2;

	    //control.bits(0x10000 | (add<<8) | reg);
	    control.bits(0x10000 | (reg<<8) | add);
	    CercVMECard[nCard]->serialWrite(&control);

	    status.bits(0x100);
	    while((status.bits()&0x100)!=0) {
	      CercVMECard[nCard]->serialRead(&status);
	    }

	    cout << "Trying " << printHex(control.bits(),false)
		 << ", reply " << printHex(status.bits(),false) << endl;
	  }
	  //}
	  */

      } break;
      case 14: {
	//VME LM82
	//CercVMECard[nCard]->readLM82();
	//cout << endl;

	SlwCercLm82StartupData d(0,7,CercLocationData::vme);
	CercVMECard[nCard]->readLm82Startup(d);
	cout << "Original VME LM82 startup data" << endl;
	d.print(cout);

	cout << endl << "Writing startup data" << endl;
	d.criticalLimit(50);
	d.localLimit(40);
	d.remoteLimit(40);
	d.configuration(0x28);
	d.print(cout);

	CercVMECard[nCard]->writeLm82Startup(d);

	SlwCercLm82StartupData d2(0,7,CercLocationData::vme);
	CercVMECard[nCard]->readLm82Startup(d2);
	cout << endl << "Read back startup data" << endl;
	d2.print(cout);

	SlwCercLm82SlowControlsData s(0,7,CercLocationData::vme);
	CercVMECard[nCard]->readLm82SlowControls(s);
	cout << endl << "Read back slow controls data" << endl;
	s.print(cout);
      } break;
      case 15: {
	//VME ADM1025
	SlwCercAdm1025StartupData a(0,7,CercLocationData::vme);
	assert(CercVMECard[nCard]->readAdm1025Startup(a));
	cout << endl << "Original startup data" << endl;
	a.print(cout);

	cout << endl << "Writing startup data" << endl;
	a.configuration(1);
	a.localHighLimit(69);
	a.localLowLimit(1);
	a.remoteHighLimit(-126);
	a.remoteLowLimit(-128);
	a.test(0);
	a.offset(1);

	SlwCercAdm1025Voltages vh;
	vh.voltage(SlwCercAdm1025Voltages::v25,201);
	vh.voltage(SlwCercAdm1025Voltages::vccp,202);
	vh.voltage(SlwCercAdm1025Voltages::v33,203);
	vh.voltage(SlwCercAdm1025Voltages::v50,204);
	vh.voltage(SlwCercAdm1025Voltages::v120,205);
	vh.voltage(SlwCercAdm1025Voltages::vcc,206);
	a.voltageHighLimits(vh);

	SlwCercAdm1025Voltages vl;
	vl.voltage(SlwCercAdm1025Voltages::v25,1);
	vl.voltage(SlwCercAdm1025Voltages::vccp,2);
	vl.voltage(SlwCercAdm1025Voltages::v33,3);
	vl.voltage(SlwCercAdm1025Voltages::v50,4);
	vl.voltage(SlwCercAdm1025Voltages::v120,5);
	vl.voltage(SlwCercAdm1025Voltages::vcc,6);
	a.voltageLowLimits(vl);

	a.print(cout);

	assert(CercVMECard[nCard]->writeAdm1025Startup(a));

	SlwCercAdm1025StartupData a2(0,7,CercLocationData::vme);
	assert(CercVMECard[nCard]->readAdm1025Startup(a2));
	cout << endl << "Read back startup data" << endl;
	a2.print(cout);

	SlwCercAdm1025SlowControlsData b(0,7,CercLocationData::vme);
	assert(CercVMECard[nCard]->readAdm1025SlowControls(b));
	cout << endl << "Read back slow controls data" << endl;
	b.print(cout);

	/*
	cout << endl;
	CercVMECard[nCard]->readADM1025A();
	cout << endl;
	CercVMECard[nCard]->writeADM1025A();
	CercVMECard[nCard]->readADM1025A();
	*/

      } break;
      case 16: {
	unsigned n;
        cout << "Enter number of triggers : ";
        cin >> n;	

	CercVmeSerialHeaderSoftwareTrigger trg;
	//CercVmeSerialHeaderFeSoftwareTrigger trg(CercVmeSerialHeader::fe0);
	for(unsigned i(0);i<n;i++) {
	  CercVMECard[nCard]->serialWrite(&trg);
	}

      } break;
      default:
        cout << "You typed an invalid option number!" << endl;
        break;
      }
    }

  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << endl;
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  cout << "This is the end, my friend..." << endl;
  return 0;
}

