#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CrcSerialCommandFeAddress.hh"
#include "CrcSerialCommandWord.hh"
#include "CrcVmeDevice.hh"
#include "CrcBeConfigurationData.hh"
#include "CrcBeTrgRunData.hh"
#include "CrcLm82StartupData.hh"
#include "CrcLm82SetupData.hh"
#include "CrcLm82SlowControlsData.hh"
//#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);


  unsigned numberOfCrcs(1);
  unsigned *addressOfCrc(new unsigned[numberOfCrcs]);
  addressOfCrc[0]=7;

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCrcs << endl;
    CrcVmeDevice *CrcVMECard[20];
    for(unsigned i(0);i<numberOfCrcs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCrc[i] << dec << endl;
      CrcVMECard[i]=new CrcVmeDevice(addressTable,busAdapter,addressOfCrc[i]);
    }

    //CrcVmeDevice CrcVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    string item, name;
    unsigned long nCard;
    vector<string> names;
    
    nCard=0;
    
    //std::string w;
    
    cout << "VME" << endl;

    assert(CrcVMECard[nCard]->reset());
    cout << "Soft reset OK" << endl << endl;

    CrcVMECard[nCard]->print(cout);

    //////////////////////////////////////////////////////
    
    CrcLm82StartupData d;
    assert(CrcVMECard[nCard]->readLm82Startup(CrcLocation::vmeLm82,d));
    d.print(cout);
    cout << endl;
    
    CrcAdm1025StartupData d1;
    assert(CrcVMECard[nCard]->readAdm1025Startup(d1));
    d1.print(cout);
    cout << endl;
    
    CrcLm82SetupData wLs,rLs;
    wLs.print(cout);
    assert(CrcVMECard[nCard]->writeLm82Setup(CrcLocation::vmeLm82,wLs));
    cout << endl;

    for(unsigned i(0);i<4;i++) {
      assert(CrcVMECard[nCard]->readLm82Setup(CrcLocation::vmeLm82,rLs));
      if(rLs!=wLs) {
	rLs.print(cout);
	cout << endl;
	i=999;
      }
    }

    CrcAdm1025SetupData wAs,rAs;
    wAs.print(cout);
    assert(CrcVMECard[nCard]->writeAdm1025Setup(wAs));

    assert(CrcVMECard[nCard]->readAdm1025Setup(rAs));
    rAs.print(cout);
    cout << endl;
    
    CrcLm82SlowControlsData f;
    assert(CrcVMECard[nCard]->readLm82SlowControls(CrcLocation::vmeLm82,f));
    f.print(cout);
    cout << endl;
    
    CrcAdm1025SlowControlsData f1;
    assert(CrcVMECard[nCard]->readAdm1025SlowControls(f1));
    f1.print(cout);
    cout << endl;
    return 0;

    ////////////////////////////////////////////////////////

    CrcBeRunData ber;
    assert(CrcVMECard[nCard]->readBeRunData(ber));
    ber.print(cout);
    cout << endl;
    
    CrcBeTrgRunData ter;
    assert(CrcVMECard[nCard]->readBeTrgRunData(ter));
    ter.print(cout);
    cout << endl;
    
    CrcBeConfigurationData wBec,rBec;
    wBec.triggerSelect(0x04);
    wBec.mode(0x01);
    wBec.readoutControl(0x02);
    wBec.runControl(0x03);
    wBec.test(0);
    wBec.feDataEnable(0x04);
    wBec.feTriggerEnable(0x04);
    wBec.daqId(0xcec);
    wBec.print(cout);
    assert(CrcVMECard[nCard]->writeBeConfigurationData(wBec));
    
    assert(CrcVMECard[nCard]->readBeConfigurationData(rBec));
    rBec.print(cout);
    cout << endl;
    
    CrcBeTrgConfigurationData wTec,rTec;
    wTec.print(cout);
    assert(CrcVMECard[nCard]->writeBeTrgConfigurationData(wTec));
    
    assert(CrcVMECard[nCard]->readBeTrgConfigurationData(rTec));
    rTec.print(cout);
    cout << endl;
    
    CrcBeEventData bee;
    assert(CrcVMECard[nCard]->readBeEventData(bee));
    bee.print(cout);
    cout << endl;
    
    CrcBeTrgEventData tee;
    assert(CrcVMECard[nCard]->readBeTrgEventData(tee));
    tee.print(cout);
    cout << endl;
    
    for(unsigned i(0);i<4;i++) {
      assert(CrcVMECard[nCard]->clearBeTrgTrigger());
      
      assert(CrcVMECard[nCard]->beSoftTrigger());
      //assert(CrcVMECard[nCard]->beTrgSoftTrigger());
      
      assert(CrcVMECard[nCard]->readBeEventData(bee));
      bee.print(cout);
      
      CrcFeEventData fee;
      assert(CrcVMECard[nCard]->readFeEventData(CrcLocation::fe2,fee));
      fee.print(cout);
      cout << endl;
    }
    
  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << " I Made This" << endl;
    
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  return 0;
}
