void HstTrgEvent(unsigned bits=0xffffffff) {

   // Histogram consumer script. Create a canvas and 3 pads. Connect
   // to memory mapped file "hsimple.map", that was created by hprod.C.
   // It reads the histograms from shared memory and displays them
   // in the pads (sleeping for 0.1 seconds before starting a new read-out
   // cycle). This script runs in an infinite loop, so use ctrl-c to stop it.

   gROOT->Reset();

   // Create a new canvas and 3 pads
   TCanvas *HstTrgEventCanvas0;
   TCanvas *HstTrgEventCanvas1;
   HstTrgEventCanvas0=new TCanvas("HstTrgEventCanvas0","HstTrgEvent0",200,10,700,780);
   HstTrgEventCanvas1=new TCanvas("HstTrgEventCanvas1","HstTrgEvent1",200,10,700,780);
   HstTrgEventCanvas0->Divide(1,3);
   HstTrgEventCanvas1->Divide(1,3);

   // Open the memory mapped file "hsimple.map" in "READ" (default) mode.
   mfile = TMapFile::Create("HstGeneric.map");

   // Print status of mapped file and list its contents
   mfile->Print();
   mfile->ls();

   // Create pointers to the objects in shared memory.
   TH1F *_hstTrgEventJobTime=0;
   TH1F *_hstTrgEventRunTime=0;
   TH1F *_hstTrgEventJobTriggers=0;
   TH1F *_hstTrgEventRunTriggers=0;
   TH1F *_hstTrgEventJobPolls=0;
   TH1F *_hstTrgEventRunPolls=0;

   // Loop displaying the histograms. Once the producer stops this
   // script will break out of the loop.
   while (true) {
     _hstTrgEventJobTime    =(TH1F*)mfile->Get("HstTrgEventJobTime");
     _hstTrgEventRunTime    =(TH1F*)mfile->Get("HstTrgEventRunTime");
     _hstTrgEventJobTriggers=(TH1F*)mfile->Get("HstTrgEventJobTriggers");
     _hstTrgEventRunTriggers=(TH1F*)mfile->Get("HstTrgEventRunTriggers");
     _hstTrgEventJobPolls   =(TH1F*)mfile->Get("HstTrgEventJobPolls");
     _hstTrgEventRunPolls   =(TH1F*)mfile->Get("HstTrgEventRunPolls");

     HstTrgEventCanvas0->cd(1);
     _hstTrgEventJobTime->Draw();
     HstTrgEventCanvas1->cd(1);
     _hstTrgEventRunTime->Draw();
     HstTrgEventCanvas0->cd(2);
     _hstTrgEventJobTriggers->Draw();
     HstTrgEventCanvas1->cd(2);
     _hstTrgEventRunTriggers->Draw();
     HstTrgEventCanvas0->cd(3);
     _hstTrgEventJobPolls->Draw();
     HstTrgEventCanvas1->cd(3);
     _hstTrgEventRunPolls->Draw();
       
     HstTrgEventCanvas0->Modified();
     HstTrgEventCanvas0->Update();
     HstTrgEventCanvas1->Modified();
     HstTrgEventCanvas1->Update();

     gSystem->Sleep(1000);   // sleep for 1 seconds
     if (gSystem->ProcessEvents()) break;
   }
}
