#ifndef BmlLalHodoscopeConfigurationData_HH
#define BmlLalHodoscopeConfigurationData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlLalHodoscopeConfigurationData {

public:
  enum {
    versionNumber=0
  };

  BmlLalHodoscopeConfigurationData();

  unsigned triggerPeriod() const;
  void     triggerPeriod(unsigned t);

  unsigned timeStamp() const;
  void     timeStamp(unsigned t);

  unsigned dummy() const;
  void     dummy(unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _triggerPeriod;
  unsigned _timeStamp;
  UtlPack _dummy;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlLalHodoscopeConfigurationData::BmlLalHodoscopeConfigurationData() {
  memset(this,0,sizeof(BmlLalHodoscopeConfigurationData));
}

unsigned BmlLalHodoscopeConfigurationData::triggerPeriod() const {
  return _triggerPeriod;
}

void BmlLalHodoscopeConfigurationData::triggerPeriod(unsigned t) {
  _triggerPeriod=t;
}

unsigned BmlLalHodoscopeConfigurationData::timeStamp() const {
  return _timeStamp;
}

void BmlLalHodoscopeConfigurationData::timeStamp(unsigned t) {
  _timeStamp=t;
}

unsigned BmlLalHodoscopeConfigurationData::dummy() const {
  return _dummy.word();
}

void BmlLalHodoscopeConfigurationData::dummy(unsigned d) {
  _dummy.word(d);
}

std::ostream& BmlLalHodoscopeConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "BmlLalHodoscopeConfigurationData::print()" << std::endl;
  o << s << " Trigger period = " << _triggerPeriod << std::endl;
  o << s << " Timestamp = " << _timeStamp << std::endl;
  o << s << " Dummy = " << printHex(_dummy) << std::endl;
  return o;
}

#endif
#endif
