#ifndef BmlLalHodoscopeEventData_HH
#define BmlLalHodoscopeEventData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlLalHodoscopeEventData {

public:
  enum {
    versionNumber=0
  };

  BmlLalHodoscopeEventData();

  bool digitalHit(unsigned xy, unsigned ch) const;

  unsigned numberOfAnalogueHits() const;
  unsigned short analogueHitChannel(unsigned n) const;
  unsigned short analogueHitValue(unsigned n) const;

  unsigned dummy() const;
  void     dummy(unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _digitalHit[2][4];
  UtlPack _dummy;
  unsigned _numberOfAnalogueHits;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlLalHodoscopeEventData::BmlLalHodoscopeEventData() {
  memset(this,0,sizeof(BmlLalHodoscopeEventData));

  for(unsigned i(0);i<2;i++) {
    for(unsigned j(0);j<4;j++) {
      _digitalHit[i][j].word(rand());
    }
  }

  _numberOfAnalogueHits=rand()%32;
  for(unsigned i(0);i<_numberOfAnalogueHits;i++) {
    UtlPack *p((UtlPack*)(this+1));
    p[i].halfWord(1,rand()%256);
    p[i].halfWord(0,rand()%4096);
  }

  print();
}

bool BmlLalHodoscopeEventData::digitalHit(unsigned xy, unsigned ch) const {
  assert(xy<2 && ch<128);
  return _digitalHit[xy][ch/32].bit(ch%32);
}

unsigned BmlLalHodoscopeEventData::numberOfAnalogueHits() const {
  return _numberOfAnalogueHits;
}

unsigned short BmlLalHodoscopeEventData::analogueHitChannel(unsigned n) const {
  assert(n<_numberOfAnalogueHits);
  const UtlPack *p((const UtlPack*)(this+1));
  return p[n].halfWord(1);
}

unsigned short BmlLalHodoscopeEventData::analogueHitValue(unsigned n) const {
  assert(n<_numberOfAnalogueHits);
  const UtlPack *p((const UtlPack*)(this+1));
  return p[n].halfWord(0);
}




unsigned BmlLalHodoscopeEventData::dummy() const {
  return _dummy.word();
}

void BmlLalHodoscopeEventData::dummy(unsigned d) {
  _dummy.word(d);
}

std::ostream& BmlLalHodoscopeEventData::print(std::ostream &o, std::string s) const {
  o << s << "BmlLalHodoscopeEventData::print()" << std::endl;

  for(unsigned xy(0);xy<2;xy++) {
    o << s << " Digital hits in ";
    if(xy==0) o << "x" << std::endl;
    else      o << "y" << std::endl;
    for(unsigned i(0);i<4;i++) {
      o << s << "  Ch " << std::setw(3) << 32*i << "-" 
	<< std::setw(3) << 32*i+31 << " = "
	<< printHex(_digitalHit[xy][i]) << std::endl;
    }
  }

  o << s << " Analogue hits" << std::endl;
  for(unsigned i(0);i<_numberOfAnalogueHits;i++) {
    o << s << "  Channel " << std::setw(5) << analogueHitChannel(i)
      << ", value " << std::setw(5) << analogueHitValue(i) << std::endl;
  }

  o << s << " Dummy = " << printHex(_dummy) << std::endl;
  return o;
}

#endif
#endif
