#ifndef BmlLalHodoscopeRunData_HH
#define BmlLalHodoscopeRunData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlLalHodoscopeRunData {

public:
  enum {
    versionNumber=0
  };

  BmlLalHodoscopeRunData();

  unsigned dummy() const;
  void     dummy(unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _dummy;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlLalHodoscopeRunData::BmlLalHodoscopeRunData() {
  memset(this,0,sizeof(BmlLalHodoscopeRunData));
}

unsigned BmlLalHodoscopeRunData::dummy() const {
  return _dummy.word();
}

void BmlLalHodoscopeRunData::dummy(unsigned d) {
  _dummy.word(d);
}

std::ostream& BmlLalHodoscopeRunData::print(std::ostream &o, std::string s) const {
  o << s << "BmlLalHodoscopeRunData::print()" << std::endl;
  o << s << " Dummy = " << printHex(_dummy) << std::endl;
  return o;
}

#endif
#endif
