#ifndef BmlLalHodoscopeTriggerData_HH
#define BmlLalHodoscopeTriggerData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class BmlLalHodoscopeTriggerData {

public:
  enum {
    versionNumber=0
  };

  BmlLalHodoscopeTriggerData();

  unsigned dummy() const;
  void     dummy(unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _dummy;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


BmlLalHodoscopeTriggerData::BmlLalHodoscopeTriggerData() {
  memset(this,0,sizeof(BmlLalHodoscopeTriggerData));
}

unsigned BmlLalHodoscopeTriggerData::dummy() const {
  return _dummy.word();
}

void BmlLalHodoscopeTriggerData::dummy(unsigned d) {
  _dummy.word(d);
}

std::ostream& BmlLalHodoscopeTriggerData::print(std::ostream &o, std::string s) const {
  o << s << "BmlLalHodoscopeTriggerData::print()" << std::endl;
  o << s << " Dummy = " << printHex(_dummy) << std::endl;
  return o;
}

#endif
#endif
