#ifndef MpsLaserConfigurationData_HH
#define MpsLaserConfigurationData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsLaserConfigurationData {

public:
  enum {
    versionNumber=0
  };

  MpsLaserConfigurationData();

  unsigned header() const;
  void     header(unsigned c);

  unsigned control() const;
  void     control(unsigned c);

  int  stageX() const;
  void stageX(int i);

  int  stageY() const;
  void stageY(int j);

  unsigned laserIntensity() const;
  void     laserIntensity(unsigned i);

  unsigned laserPeriod() const;
  void     laserPeriod(unsigned p);

  bool        parse(const std::string &r);
  std::string parse() const;

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _header;
  UtlPack _control;
  int _stageX;
  int _stageY;
  unsigned _laserIntensity;
  unsigned _laserPeriod;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsLaserConfigurationData::MpsLaserConfigurationData() {
  memset(this,0,sizeof(MpsLaserConfigurationData));
  _header=0xaaaa5555;
}

unsigned MpsLaserConfigurationData::header() const {
  return _header;
}

void MpsLaserConfigurationData::header(unsigned c) {
  _header=c;
}

unsigned MpsLaserConfigurationData::control() const {
  return _control.word();
}

void MpsLaserConfigurationData::control(unsigned c) {
  _control=c;
}

int MpsLaserConfigurationData::stageX() const {
  return _stageX;
}

void MpsLaserConfigurationData::stageX(int i) {
  _stageX=i;
}

int MpsLaserConfigurationData::stageY() const {
  return _stageY;
}

void MpsLaserConfigurationData::stageY(int j) {
  _stageY=j;
}
 
std::string MpsLaserConfigurationData::parse() const {
  std::ostringstream sout;

  sout << std::setw(12) << _header;

  if(_control.bit(0)) sout << std::setw(12) << 1;
  else                sout << std::setw(12) << 0;
  if(_control.bit(1)) sout << std::setw(12) << 1;
  else                sout << std::setw(12) << 0;

  sout << std::setw(12) << _stageX;
  sout << std::setw(12) << _stageY;
  sout << std::setw(12) << _laserIntensity;
  sout << std::setw(12) << _laserPeriod;

  return sout.str();
}
 
bool MpsLaserConfigurationData::parse(const std::string &r) {
  std::istringstream sin(r);
 
  sin >> _header;
  if(!sin) return false;
 
  unsigned temp;
  sin >> temp;
  if(!sin) return false;
  _control.bit(0,temp);

  sin >> temp;
  if(!sin) return false;
  _control.bit(1,temp);

  sin >> _stageX;
  if(!sin) return false;
  
  sin >> _stageY;
  if(!sin) return false;
 
  sin >> _laserIntensity;
  if(!sin) return false;
  
  sin >> _laserPeriod;
  if(!sin) return false;


  return sin;
}

std::ostream& MpsLaserConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "MpsLaserConfigurationData::print()" << std::endl;
  o << s << " Header = " << _header << std::endl;

  o << s << " Control = " << printHex(_control) << std::endl;
  o << s << "  Master ";
  if(_control.bit(0)) o << "true";
  else                o << "false";
  o << s << "  Singe shot ";
  if(_control.bit(1)) o << "true";
  else                o << "false";

  o << s << " Position x = " << stageX()
    << ", y = " << stageY() << std::endl;
  o << s << " Laser intensity = " << _laserIntensity <<std::endl;
  o << s << " Laser period = " << _laserPeriod <<std::endl;
  return o;
}

#endif
#endif
