#ifndef MpsLaserRunData_HH
#define MpsLaserRunData_HH

#include <iostream>
#include <fstream>


class MpsLaserRunData {

public:
  enum {
    versionNumber=0
  };

  MpsLaserRunData();

  unsigned header() const;

  unsigned stepSizeX() const;
  void     stepSizeX(unsigned s);

  unsigned stepSizeY() const;
  void     stepSizeY(unsigned s);

  unsigned spotSizeX() const;
  void     spotSizeX(unsigned s);

  unsigned spotSizeY() const;
  void     spotSizeY(unsigned s);

  unsigned focusParameter() const;
  void     focusParameter(unsigned s);

  bool parse(const std::string &r);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _header;
  unsigned _stepSizeX;
  unsigned _stepSizeY;
  unsigned _spotSizeX;
  unsigned _spotSizeY;
  unsigned _focusParameter;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsLaserRunData::MpsLaserRunData() {
  memset(this,0,sizeof(MpsLaserRunData));
}

unsigned MpsLaserRunData::header() const {
  return _header;
}

unsigned MpsLaserRunData::stepSizeX() const {
  return _stepSizeX;
}

void MpsLaserRunData::stepSizeX(unsigned s) {
  _stepSizeX=s;
}

unsigned MpsLaserRunData::stepSizeY() const {
  return _stepSizeY;
}

void MpsLaserRunData::stepSizeY(unsigned s) {
  _stepSizeY=s;
}

unsigned MpsLaserRunData::spotSizeX() const {
  return _spotSizeX;
}

void MpsLaserRunData::spotSizeX(unsigned s) {
  _spotSizeX=s;
}

unsigned MpsLaserRunData::spotSizeY() const {
  return _spotSizeY;
}

void MpsLaserRunData::spotSizeY(unsigned s) {
  _spotSizeY=s;
}

unsigned MpsLaserRunData::focusParameter() const {
  return _focusParameter;
}

void MpsLaserRunData::focusParameter(unsigned s) {
  _focusParameter=s;
}

bool MpsLaserRunData::parse(const std::string &r) {
  std::istringstream sin(r);

  sin >> _header;
  if(!sin) return false;
 
  sin >> _stepSizeX;
  if(!sin) return false;
 
  sin >> _stepSizeY;
  if(!sin) return false;
 
  sin >> _spotSizeX;
  if(!sin) return false;
 
  sin >> _spotSizeY;
  if(!sin) return false;
 
  sin >> _focusParameter;
  if(!sin) return false;
 
  return sin;
}

std::ostream& MpsLaserRunData::print(std::ostream &o, std::string s) const {
  o << s << "MpsLaserRunData::print()" << std::endl;

  o << s << " Header = " << _header << std::endl;
  o << s << " Step sizes: x = " << _stepSizeX
    << ", y = " << _stepSizeY << std::endl;
  o << s << " Spot sizes: x = " << _spotSizeX
    << ", y = " << _spotSizeY << std::endl;
  o << s << " Focus parameter = " << _focusParameter << std::endl;

  return o;
}

#endif
#endif
