#ifndef MpsUsbDaqBunchTrainData_HH
#define MpsUsbDaqBunchTrainData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsUsbDaqBunchTrainData {

public:
  enum {
    versionNumber=0
  };

  MpsUsbDaqBunchTrainData();

  unsigned numberOfTries() const;
  void     numberOfTries(unsigned n);

  unsigned numberOfTrgs() const;
  void     numberOfTrgs(unsigned n);

  std::vector<unsigned> trgVector() const;
  void                  trgVector(const std::vector<unsigned> &v);
 
  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _numberOfTries;
  unsigned _numberOfTrgs;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsUsbDaqBunchTrainData::MpsUsbDaqBunchTrainData() {
  memset(this,0,sizeof(MpsUsbDaqBunchTrainData));
}

unsigned MpsUsbDaqBunchTrainData::numberOfTries() const {
  return _numberOfTries;
}

void MpsUsbDaqBunchTrainData::numberOfTries(unsigned n) {
  _numberOfTries=n;
}

unsigned MpsUsbDaqBunchTrainData::numberOfTrgs() const {
  return _numberOfTrgs;
}

void MpsUsbDaqBunchTrainData::numberOfTrgs(unsigned n) {
  _numberOfTrgs=n;
}

std::vector<unsigned> MpsUsbDaqBunchTrainData::trgVector() const {
  std::vector<unsigned> v;
  const unsigned *p((const unsigned*)(this+1));
  for(unsigned i(0);i<_numberOfTrgs;i++) {
    v.push_back(p[i]);
  }
  return v;
}
 
void MpsUsbDaqBunchTrainData::trgVector(const std::vector<unsigned> &v) {
  unsigned *p((unsigned*)(this+1));
  for(unsigned i(0);i<v.size();i++) {
    p[i]=v[i];
  }
  _numberOfTrgs=v.size();
}

std::ostream& MpsUsbDaqBunchTrainData::print(std::ostream &o, std::string s) const {
  o << s << "MpsUsbDaqBunchTrainData::print()" << std::endl;
  o << s << " Number of tries = " << _numberOfTries << std::endl;
  o << s << " Number of trgs = " << _numberOfTrgs << std::endl;

  const unsigned *p((const unsigned*)(this+1));
  for(unsigned i(0);i<_numberOfTrgs;i++) {
    o << s << "  Trg " << std::setw(4) << i << " = "
      << printHex(p[i]) << std::endl;
  }

  return o;
}

#endif
#endif
