#ifndef MpsUsbDaqRunData_HH
#define MpsUsbDaqRunData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsUsbDaqRunData {

public:
  enum {
    versionNumber=0
  };

  MpsUsbDaqRunData();

  unsigned firmwareVersion() const;
  void     firmwareVersion(unsigned v);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _firmwareVersion;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsUsbDaqRunData::MpsUsbDaqRunData() {
  memset(this,0,sizeof(MpsUsbDaqRunData));
}

unsigned MpsUsbDaqRunData::firmwareVersion() const {
  return _firmwareVersion;
}

void MpsUsbDaqRunData::firmwareVersion(unsigned v) {
  _firmwareVersion=v;
}

std::ostream& MpsUsbDaqRunData::print(std::ostream &o, std::string s) const {
  o << s << "MpsUsbDaqRunData::print()" << std::endl;
  o << s << " Firmware version = " << printHex(_firmwareVersion) << std::endl;
  return o;
}

#endif
#endif
