// renoir header_start
//
// Module chan_quad.command_decoder.behavioral
//
// Created:
//          by - wjfg72.UNKNOWN (TE2MANAGUA)
//          at - 11:55:52 25/06/01
//
// Generated by Mentor Graphics' Renoir(TM) 2000.3 (Build 2)
//
// renoir header_end

`resetall
`timescale 1ns/1ps

//these are designator values in decimal
`define trigger_select	1	// trigger select reg
`define mode_reg		2	// mode select register
`define ttc_rx_cntl		3	// TTCrx control
`define test_reg		4 	// test Register
`define fe_enable_reg	5	// FE enable register
`define be_rdout_cntl	6	// back end read out control
`define be_run_cntl		7	// back end run control
`define sw_trigger		8	// software trigger
`define soft_rst		9   // software reset
`define fed_id_reg		10	// FED ID register set by software
`define ttc_rx_rst		11	// TTC rx Reset signal
`define lm82_cntl		12	// LM82 control register

`define be_status_reg		16	// Back end status register
`define rd_L1A_count		17	// read L1A counter
`define rd_bx_count			18	// read bunch crossing counter
`define qdr_frame_count		19	// read QDR frame counter
`define TTC_ready			20	// read TTC status register 
`define firmware_id_reg		21	// read firmware ID reg read only = UserCode
`define qdr_data_count		22	// read QDR data counter
`define total_frame_count	23	// read total frame counter
`define ttc_status			24	// TTCrx I2C data in
`define lm82_status			25	// LM82 I2C data in
`define ttc_single_cmnd		26	// read ttc single command/data reg read only
`define ttc_brdcst_cmnd		27	// read ttc broadcast command/data read only

module BE_cmnd_decoder(
		clk, rst, command_in, command_out, command_real, 
	 	trigger_select, mode_reg, ttc_rx_cntl, test_reg,
		fe_enable_reg, be_rdout_cntl, be_run_cntl, sw_trigger, 
		soft_rst, fed_id_reg, ttc_rx_rst, lm82_cntl,
 		be_status_reg, rd_L1A_count, rd_bx_count, qdr_frame_count,
		TTC_ready, firmware_id_reg, qdr_data_count, total_frame_count, 
		ttc_status, ttc_i2c_en, lm82_status, lm82_i2c_en,	
		data_valid, ttc_single_cmnd, ttc_brdcst_cmnd);

	
parameter DESIGNATOR = 5; 		// Number of bits in Command Designator
parameter LENGTH_FIELD = 16; 	// Number of bits in Command Length
// parameter RESET_LENGTH = 16; // Number of zeros that constitute a reset

// Internal Declarations

input clk, rst, command_in;
input [31:0] be_status_reg;		// Back end status register
input [23:0] rd_L1A_count;		// read L1A counter
input [11:0] rd_bx_count;		// read bunch crossing counter
input [23:0] qdr_frame_count;	// read QDR frame counter
input TTC_ready;				// read TTC ready signal
input [31:0] firmware_id_reg;	// read user code
input [17:0] qdr_data_count;	// read QDR data counter
input [23:0] total_frame_count;	// read total frame counter
input [15:0] ttc_status;		// read TTCrx I2C data in
input [15:0] lm82_status;		// read LM82 I2C data in

output command_out;
output command_real;
output [2:0] trigger_select;
output [15:0] ttc_rx_cntl;	    // TTCrx control register
output [1:0] mode_reg, be_rdout_cntl, be_run_cntl;
output [31:0] test_reg;
output sw_trigger, soft_rst;
output [7:0] fe_enable_reg;
output [11:0] fed_id_reg;
output ttc_i2c_en, lm82_i2c_en;
output data_valid;
output ttc_rx_rst;
output [16:0] lm82_cntl;	    // LM82 control register

// a process
reg [LENGTH_FIELD-1:0] length;
reg r_wB;
reg [DESIGNATOR-1:0] designator;
reg [1:0] state;
reg data_valid;

always @(posedge clk or posedge rst)
begin
	if (rst)
		begin
		state <= #1 0;
		r_wB <= #1 0;
		length <= #1 0;
		designator <= #1 0;
		data_valid <= #1 0;
		end
	else
	begin
		case (state)
		0:
		begin
		// Shift in the command stream until a Designator is recognised
		r_wB <= #1 designator[DESIGNATOR-1];						 // assign bit 4
		designator <= #1 {designator[DESIGNATOR-2:0], command_in};   // assign bits 3 : 0  ie the designator
		data_valid <= #1 0;
		if (r_wB)		    // upon detection of first '1' go into state 1
			begin
			state <= #1 1;
			end
		end
		1:
		begin
			length <= #1 {length[LENGTH_FIELD-2:0], command_in};	   // length indicates the no. of data bits to follow
			data_valid <= #1 0;
			if (length[LENGTH_FIELD-1])	   // find the first '1'
				begin
				state <= #1 2;
				end
		end
		2:								   // stay in state 2 for the length number of clock cycles 
		begin							   // which equals the number of data bits to follow
			length <= #1 length - 1;
			data_valid <= #1 0;
			if (length == 1)
			begin
				if (r_wB)				   // if read cycle then reset everything
					begin
					state <= #1 0;
					designator <= #1 0;
					r_wB <= #1 0;
					end
				else					   // if write cycle then assert data valid
					begin
					state <= #1 3;
					designator <= #1 0;
					r_wB <= #1 0;
					end
			end
		end
		3:
		begin
			data_valid <= #1 1;   // assign a 1 to data valid
			state <= #1 0;
		end
		endcase
	end
end
// end of process



// these are strobe signals for loading the registers
reg load_trigger_select;
reg load_mode_reg;
reg load_ttc_rx_cntl, load_ttc_rx_cntl_2, load_ttc_rx_cntl_3;	  // two copies of original 
reg load_lm82_cntl, load_lm82_cntl_2, load_lm82_cntl_3;	  		// two copies of original 
reg load_test_reg;
reg load_fe_enable_reg;
reg load_be_rdout_cntl;
reg load_be_run_cntl;
reg load_sw_trigger;
reg load_fed_id_reg;		
reg load_soft_rst;
reg load_ttc_rx_rst;
reg load_be_status_reg1, load_be_status_reg2;
reg load_rd_L1A_count_reg1, load_rd_L1A_count_reg2;
reg load_rd_bx_count_reg1, load_rd_bx_count_reg2;
reg load_qdr_frame_count_reg1, load_qdr_frame_count_reg2;
reg load_TTC_ready1;
reg load_firmware_id_reg1, load_firmware_id_reg2;
reg load_qdr_data_count_reg1, load_qdr_data_count_reg2;
reg load_total_frame_count_reg1, load_total_frame_count_reg2;
reg load_ttc_status_reg1, load_ttc_status_reg2;
reg load_lm82_status_reg1, load_lm82_status_reg2;

// this process generates the relevant load strobe
always @(posedge clk or posedge rst)
begin
	if (rst)
		begin
		load_trigger_select <= #1 0;
		load_mode_reg <= #1 0;
		load_ttc_rx_cntl <= #1 0;
		load_ttc_rx_cntl_2 <= #1 0;
		load_ttc_rx_cntl_3 <= #1 0;
		load_lm82_cntl <= #1 0;
		load_lm82_cntl_2 <= #1 0;
		load_lm82_cntl_3 <= #1 0;
		load_test_reg <= #1 0;
		load_fe_enable_reg <= #1 0;
		load_be_rdout_cntl <= #1 0;
		load_be_run_cntl <= #1 0;
		load_sw_trigger <= #1 0;
		load_fed_id_reg <= #1 0;
		load_soft_rst <= #1 0;
		load_ttc_rx_rst <= #1 0;
		load_be_status_reg1 <= #1 0;
		load_be_status_reg2 <= #1 0;
		load_rd_L1A_count_reg1 <= #1 0;
		load_rd_L1A_count_reg2 <= #1 0;
		load_rd_bx_count_reg1 <= #1 0;
		load_rd_bx_count_reg2 <= #1 0;
		load_qdr_frame_count_reg1 <= #1 0;
		load_qdr_frame_count_reg2 <= #1 0;
		load_TTC_ready1 <= #1 0;
		load_firmware_id_reg1 <= #1 0;
		load_firmware_id_reg2 <= #1 0;
		load_qdr_data_count_reg1 <= #1 0;
		load_qdr_data_count_reg2 <= #1 0;
		load_total_frame_count_reg1 <= #1 0;
		load_total_frame_count_reg2 <= #1 0;
		load_ttc_status_reg1 <= #1 0;
		load_ttc_status_reg2 <= #1 0;
		load_lm82_status_reg1 <= #1 0;
		load_lm82_status_reg2 <= #1 0;
		end
	else
		begin
		load_trigger_select <= #1 (state == 2) & (designator == `trigger_select);
		load_mode_reg <= #1 (state == 2) & (designator == `mode_reg);
		load_ttc_rx_cntl <= #1 (state == 2) & (designator == `ttc_rx_cntl);
		load_ttc_rx_cntl_2 <= #1 load_ttc_rx_cntl;
		load_ttc_rx_cntl_3 <= #1 load_ttc_rx_cntl_2;
		load_lm82_cntl <= #1 (state == 2) & (designator == `lm82_cntl);
		load_lm82_cntl_2 <= #1 load_lm82_cntl;
		load_lm82_cntl_3 <= #1 load_lm82_cntl_2;
		load_test_reg <= #1 (state == 2) & (designator == `test_reg);
		load_fed_id_reg <= #1 (state == 2) & (designator == `fed_id_reg);  // this is strobe signal for loading the reg
		load_fe_enable_reg <= #1 (state == 2) & (designator == `fe_enable_reg);
		load_be_rdout_cntl <= #1 (state == 2) & (designator == `be_rdout_cntl);
		load_be_run_cntl <= #1 (state == 2) & (designator == `be_run_cntl);
		load_sw_trigger <= #1 (state == 2) & (designator == `sw_trigger);
		load_soft_rst <= #1 (state == 2) & (designator == `soft_rst);
		load_ttc_rx_rst <= #1 (state == 2) & (designator == `ttc_rx_rst);
		load_be_status_reg1 <= #1 (state == 2) & (designator == `be_status_reg);
		load_be_status_reg2 <= #1 load_be_status_reg1;
		load_rd_L1A_count_reg1 <= #1 (state == 2) & (designator == `rd_L1A_count);
		load_rd_L1A_count_reg2 <= #1 load_rd_L1A_count_reg1;
		load_rd_bx_count_reg1 <= #1 (state == 2) & (designator == `rd_bx_count);
		load_rd_bx_count_reg2 <= #1 load_rd_bx_count_reg1;
		load_qdr_frame_count_reg1 <= #1 (state == 2) & (designator == `qdr_frame_count);
		load_qdr_frame_count_reg2 <= #1 load_qdr_frame_count_reg1;
		load_TTC_ready1 <= #1 (state == 2) & (designator == `TTC_ready);
		load_firmware_id_reg1 <= #1 (state == 2) & (designator == `firmware_id_reg);
		load_firmware_id_reg2 <= #1 load_firmware_id_reg1;
		load_qdr_data_count_reg1 <= #1 (state == 2) & (designator == `qdr_data_count);
		load_qdr_data_count_reg2 <= #1 load_qdr_data_count_reg1;
		load_total_frame_count_reg1 <= #1 (state == 2) & (designator == `total_frame_count);
		load_total_frame_count_reg2 <= #1 load_total_frame_count_reg1;
		load_ttc_status_reg1 <= #1 (state == 2) & (designator == `ttc_status);
		load_ttc_status_reg2 <= #1 load_ttc_status_reg1;
		load_lm82_status_reg1 <= #1 (state == 2) & (designator == `lm82_status);
		load_lm82_status_reg2 <= #1 load_lm82_status_reg1;
		end
end
//end of process


// new process which clocks data in and out of the registers
// define output registers here
reg [2:0] trigger_select;		// trigger select reg
reg [1:0] mode_reg;				// mode select register
reg [15:0] ttc_rx_cntl;			// TTCrx I2C interface
reg [31:0] test_reg;		 	//test Register
reg [7:0] fe_enable_reg;		// FE enable register
reg [1:0] be_rdout_cntl;		// back end read out control
reg [1:0] be_run_cntl;			// back end run control
reg sw_trigger;					// software trigger
reg ttc_rx_rst;					// TTCrx hardware reset
reg [11:0] fed_id_reg;			// FED ID register set by software
reg [31:0] be_status_shift_reg;		// shift reg to hold BE status reg for reading
reg [23:0] rd_L1A_count_shift_reg;	// shift reg to hold L1Accept counter value for reading
reg [11:0] rd_bx_count_shift_reg;	// shift reg to hold rd_bx_count counter value for reading
reg [23:0] qdr_frame_count_shift_reg;
reg [31:0] firmware_id_shift_reg;
reg [17:0] qdr_data_count_shift_reg;
reg [23:0] total_frame_count_shift_reg;
reg [15:0] ttc_status_shift_reg;
reg [15:0] lm82_status_shift_reg;
reg ttc_i2c_en;
reg lm82_i2c_en;
reg [16:0] lm82_cntl;			// LM82 I2C interface

always @(posedge clk or posedge rst)
begin
	if (rst)
		begin
			trigger_select <= #1 3'b100; // software trigger
			mode_reg <= #1 2'b01;		// 01 = scope mode  10 = frame finding mode
//			test_reg <= #1 32'b00000000000000000000000000000010;  // ignore throttle for test only
			test_reg <= #1 32'b00000000000000000000000000000000;  // ignore throttle disabled
			fe_enable_reg <= #1 8'b11111111;   // entre default values here if none zero
			be_rdout_cntl <= #1 2'b10;	// 01 = S-LINK   10 = V-LINK   00 = disabled
			be_run_cntl <= #1 2'b11;	// 11 = enable run control
			sw_trigger <= #1 0;
			ttc_rx_cntl <= #1 0;
			ttc_rx_rst <= #1 0;
			ttc_i2c_en <= #1 0;
			ttc_status_shift_reg <= #1 0;
			fed_id_reg <= #1 12'b111111101101;	   // 0xFED
			be_status_shift_reg <= #1 0;
			rd_L1A_count_shift_reg <= #1 0;
			rd_bx_count_shift_reg <= #1 0;
			qdr_frame_count_shift_reg <= #1 0;
			firmware_id_shift_reg <= #1 0;	  //user code eg: 0x12000211 
			qdr_data_count_shift_reg <= #1 0;
			total_frame_count_shift_reg <= #1 0;
			lm82_cntl <= #1 0;
			lm82_i2c_en <= #1 0;
			lm82_status_shift_reg <= #1 0;
		end
	else
		begin
			if (load_trigger_select)
				begin
				trigger_select <= #1 {trigger_select[1:0], command_real};
				end
	
			if (load_mode_reg)
				begin
				mode_reg <= #1 {mode_reg[0], command_real};
				end
	
			if (load_ttc_rx_cntl)
				begin
				ttc_rx_cntl <= #1 {ttc_rx_cntl[14:0], command_real};
				end
	
				ttc_i2c_en <= #1 (data_valid & load_ttc_rx_cntl_3);	   // enable TTCrx I2C interface 

			if (load_lm82_cntl)
				begin
				lm82_cntl <= #1 {lm82_cntl[15:0], command_real};
				end
	
				lm82_i2c_en <= #1 (data_valid & load_lm82_cntl_3);	   // enable LM82 I2C interface 

			if (load_test_reg)
				begin
				test_reg <= #1 {test_reg[30:0], command_real};
				end
	
			if (load_fe_enable_reg)
				begin
				fe_enable_reg <= #1 {fe_enable_reg[6:0], command_real};
				end
	
			if (load_be_rdout_cntl)
				begin
				be_rdout_cntl <= #1 {be_rdout_cntl[0], command_real};
				end
	
			if (load_be_run_cntl)
				begin
				be_run_cntl <= #1 {be_run_cntl[0], command_real};
				end
	
			if (load_sw_trigger)
				begin
				sw_trigger <= #1 1;	    // set to 1
				end
			else
				begin
				sw_trigger <= #1 0;	    // set to 0
				end

			if (load_ttc_rx_rst)
				begin
				ttc_rx_rst <= #1 1;	    // set to 1
				end
			else
				begin
				ttc_rx_rst <= #1 0;	    // set to 0
				end

			if (load_fed_id_reg)
				begin
				fed_id_reg <= #1 {fed_id_reg[10:0], command_real};
				end

			if (load_be_status_reg1 & !load_be_status_reg2)  // this parallel loads the be_status_reg 
				begin										 // into the internal shift register
				be_status_shift_reg <= #1 be_status_reg;	 // after load_be_status_reg1 = 1 and load_be_status_reg2 = 0
				end
			if (load_be_status_reg2)						 // this reads 31 bits of the be_status_shift_reg
				begin
				be_status_shift_reg <= #1 {be_status_shift_reg[30:0], command_real};
				end

			if (load_rd_L1A_count_reg1 & !load_rd_L1A_count_reg2)	// this parallel loads the rd_L1A_count 
				begin										 		// into the internal shift register
				rd_L1A_count_shift_reg <= #1 rd_L1A_count;			// after load_rd_L1A_count_reg1 = 1 and load_rd_L1A_count_reg2 = 0
				end
			if (load_rd_L1A_count_reg2)						 		// this reads 24 bits of the rd_L1A_count_shift_reg
				begin
				rd_L1A_count_shift_reg <= #1 {rd_L1A_count_shift_reg[22:0], command_real};
				end

			if (load_rd_bx_count_reg1 & !load_rd_bx_count_reg2) 
				begin
				rd_bx_count_shift_reg <= #1 rd_bx_count;
				end
			if (load_rd_bx_count_reg2)
				begin
				rd_bx_count_shift_reg <= #1 {rd_bx_count_shift_reg[10:0], command_real};
				end

			if (load_qdr_frame_count_reg1 & !load_qdr_frame_count_reg2) 
				begin
				qdr_frame_count_shift_reg <= #1 qdr_frame_count;
				end
			if (load_qdr_frame_count_reg2)
				begin
				qdr_frame_count_shift_reg <= #1 {qdr_frame_count_shift_reg[22:0], command_real};
				end

			if (load_firmware_id_reg1 & !load_firmware_id_reg2) 
				begin
				firmware_id_shift_reg <= #1 firmware_id_reg;
				end
			if (load_firmware_id_reg2)
				begin
				firmware_id_shift_reg <= #1 {firmware_id_shift_reg[30:0], command_real};
				end

			if (load_qdr_data_count_reg1 & !load_qdr_data_count_reg2) 
				begin
				qdr_data_count_shift_reg <= #1 qdr_data_count;
				end
			if (load_qdr_data_count_reg2)
				begin
				qdr_data_count_shift_reg <= #1 {qdr_data_count_shift_reg[16:0], command_real};
				end

			if (load_total_frame_count_reg1 & !load_total_frame_count_reg2) 
				begin
				total_frame_count_shift_reg <= #1 total_frame_count;
				end
			if (load_total_frame_count_reg2)
				begin
				total_frame_count_shift_reg <= #1 {total_frame_count_shift_reg[22:0], command_real};
				end

			if (load_ttc_status_reg1 & !load_ttc_status_reg2) 
				begin
				ttc_status_shift_reg <= #1 ttc_status;
				end
			if (load_ttc_status_reg2)
				begin
				ttc_status_shift_reg <= #1 {ttc_status_shift_reg[14:0], command_real};
				end

			if (load_lm82_status_reg1 & !load_lm82_status_reg2) 
				begin
				lm82_status_shift_reg <= #1 lm82_status;
				end
			if (load_lm82_status_reg2)
				begin
				lm82_status_shift_reg <= #1 {lm82_status_shift_reg[14:0], command_real};
				end

		end
end


wire [31:0] command_word =
	{5'b0,							// 28-31
	ttc_brdcst_cmnd,				// 27
	ttc_single_cmnd,				// 26
	lm82_status_shift_reg[15],		// 25
	ttc_status_shift_reg[15],		// 24
	total_frame_count_shift_reg[23],// 23
	qdr_data_count_shift_reg[17],	// 22
	firmware_id_shift_reg[31],		// 21
	TTC_ready,	    				// 20
	qdr_frame_count_shift_reg[23],	// 19
	rd_bx_count_shift_reg[11],		// 18
	rd_L1A_count_shift_reg[23],		// 17
	be_status_shift_reg[31],		// 16
	1'b0,			    			// 15
	1'b0,			    			// 14
	1'b0,			    			// 13
	lm82_cntl[16],					// 12
	1'b0,							// 11
	fed_id_reg[11],	    			// 10
	1'b0,			    // 9
	1'b0,	   			// 8
	be_run_cntl[1],		// 7
	be_rdout_cntl[1],	// 6
	fe_enable_reg[7],	// 5    this is the msb of the register
	test_reg[31],	    // 4
	ttc_rx_cntl[15], 	// 3
	mode_reg[1],		// 2
	trigger_select[2],	// 1
	1'b0};				// 0 unused


reg command_out, command_real;
always @(posedge clk or posedge rst)
begin
	if (rst)
		begin
		command_out <= #1 0;
		command_real <= #1 0;
		end
	else
		begin
		command_out <= #1 (state == 2) & command_word[designator];		     // output the bit in command word which equals the designator
		command_real <= #1 (r_wB ? command_word[designator] : command_in);
		end
end

// this process generates the soft reset signal
reg load_soft_rst2;
always @(negedge clk or posedge rst)
begin
	if (rst)
		begin
		load_soft_rst2 <= #1 0;
		end
	else
		begin
		load_soft_rst2 <= #1 load_soft_rst;
		end
end
assign #1 soft_rst = (load_soft_rst2 | rst);
// end of process

endmodule
