-- hds header_start
--
-- VHDL Architecture back_end_fpga.L1A_bx_flag_gen.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 14:11:31 03/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.ALL;
USE ieee.std_logic_unsigned.all;

ENTITY L1A_bx_flag_gen IS
   PORT( 
      L1A_bx_flags   : IN     std_logic_vector (2 DOWNTO 0);
      clk2x          : IN     std_logic;
      reset          : IN     std_logic;
      L1A_bx_25_flag : OUT    std_logic;
      L1A_bx_50_flag : OUT    std_logic;
      L1A_bx_87_flag : OUT    std_logic
   );

-- Declarations

END L1A_bx_flag_gen ;

-- hds interface_end
ARCHITECTURE rtl OF L1A_bx_flag_gen IS
BEGIN
Process (clk2x, reset)
	begin
	if reset = '1' then
		L1A_bx_87_flag <= '0' after 1 ns;
		L1A_bx_50_flag <= '0' after 1 ns;
		L1A_bx_25_flag <= '0' after 1 ns;
	elsif clk2x'event AND clk2x = '1' then
		if conv_integer(L1A_bx_flags) > 6 then  		-- 87% full
			L1A_bx_87_flag <= '1' after 1 ns;
			L1A_bx_50_flag <= '1' after 1 ns;
			L1A_bx_25_flag <= '1' after 1 ns;
		elsif conv_integer(L1A_bx_flags) > 3 then  		-- 50% full
			L1A_bx_87_flag <= '0' after 1 ns;
			L1A_bx_50_flag <= '1' after 1 ns;
			L1A_bx_25_flag <= '1' after 1 ns;
		elsif conv_integer(L1A_bx_flags) > 1 then  		-- 25% full
			L1A_bx_87_flag <= '0' after 1 ns;
			L1A_bx_50_flag <= '0' after 1 ns;
			L1A_bx_25_flag <= '1' after 1 ns;
		else   										-- memory is not empty
			L1A_bx_87_flag <= '0' after 1 ns;
			L1A_bx_50_flag <= '0' after 1 ns;
			L1A_bx_25_flag <= '0' after 1 ns;
		end if;
	end if;	
end process;
END rtl;
