-- hds header_start
--
-- VHDL Architecture back_end_fpga.L1A_decoder.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 09:08:47 01/16/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.ALL;
USE ieee.std_logic_unsigned.all;

ENTITY L1A_decoder IS
   PORT( 
      L1_accept_decode : IN     std_logic_vector (4 DOWNTO 0);
      clk1x            : IN     std_logic;
      reset            : IN     std_logic;
      FE_trigger       : OUT    std_logic;
      TTC_reset        : OUT    std_logic
   );

-- Declarations

END L1A_decoder ;

-- hds interface_end
ARCHITECTURE rtl OF L1A_decoder IS
BEGIN

Process (clk1x, reset)
	variable L1_accept_temp : std_logic := '0';
	variable TTC_reset_temp : std_logic := '0';

	Begin
	if reset = '1' then
		L1_accept_temp := '0';
		TTC_reset_temp := '0';
	elsif clk1x'event and clk1x='1' then
		if L1_accept_decode = "00100" then					-- This code represents an L1Accept code
			L1_accept_temp := '1';
		elsif L1_accept_decode(2 downto 0) = "101" then		-- This code represents a RESET code
			TTC_reset_temp := '1';
		else
			L1_accept_temp := '0';
			TTC_reset_temp := '0';
		end if;
	end if;
	FE_trigger <= L1_accept_temp after 1 ns;
	TTC_reset <= TTC_reset_temp after 1 ns;
	end process;		
END rtl;
