
ARCHITECTURE behave OF MT54V512H18A IS
    TYPE memory  IS ARRAY (mem_sizes DOWNTO 0) OF STD_LOGIC_VECTOR (data_bits - 1 DOWNTO 0);
    TYPE a3xaddr IS ARRAY (2 DOWNTO 0) OF STD_LOGIC_VECTOR (addr_bits - 1 DOWNTO 0);
    TYPE a3xcmnd IS ARRAY (2 DOWNTO 0) OF STD_LOGIC;

    SIGNAL C_Int : STD_LOGIC;
    SIGNAL C_Int_n : STD_LOGIC;
    SIGNAL Output_Buf : STD_LOGIC_VECTOR (data_bits - 1 DOWNTO 0) := (OTHERS => 'Z');
BEGIN
    -- Output Buffer
    Q <= Output_buf AFTER tCHQV;

-- the following section has been commented out to make code compile
    
    -- Internal Output Clock Generators
--    WITH C SELECT
--        C_Int  <= K AFTER 1 ps WHEN C_n,
--                  C AFTER 1 ps WHEN NOT(C_n),
--                  K AFTER 1 ps WHEN OTHERS; 
--    
--    WITH C_n SELECT
--        C_Int_n  <= K_n AFTER 1 ps WHEN C,
--                    C_n AFTER 1 ps WHEN NOT(C),
--                    K_n AFTER 1 ps WHEN OTHERS;
    

-- the clocks have been modified to make the code compile
		C_Int  <= K AFTER 1 ps ;
        C_Int_n  <= K_n AFTER 1 ps ;

    main : PROCESS
        -- Memory Array
        VARIABLE Bank0 : memory;
        
        -- Declar Connection Variables
        VARIABLE Data_in_enable  : STD_LOGIC := '0';
        VARIABLE Data_out_enable : STD_LOGIC := '0';

        VARIABLE Output_reg    : STD_LOGIC_VECTOR (data_bits - 1 DOWNTO 0) := (OTHERS => 'Z');
        VARIABLE Addr_read_reg : STD_LOGIC_VECTOR (addr_bits - 1 DOWNTO 0);

        VARIABLE Bw_reg    : STD_LOGIC_VECTOR (1 DOWNTO 0);
        VARIABLE Input_buf : STD_LOGIC_VECTOR (data_bits - 1 DOWNTO 0);
        VARIABLE Input_reg : STD_LOGIC_VECTOR (data_bits - 1 DOWNTO 0);

        -- Pipeline Variables
        VARIABLE Addr_pipe : a3xaddr;
        VARIABLE Cmnd_pipe : a3xcmnd;

        -- Counter
        VARIABLE Data_read_counter  : INTEGER;
        VARIABLE Burst_read_counter : STD_LOGIC;

        -- Convert a std_logic value to a character
        TYPE stdlogic_to_char_t IS ARRAY (STD_LOGIC) OF CHARACTER;
        CONSTANT to_char : stdlogic_to_char_t := (
            'U' => 'U',
            'X' => 'X',
            '0' => '0',
            '1' => '1',
            'Z' => 'Z',
            'W' => 'W',
            'L' => 'L',
            'H' => 'H',
            '-' => '-'
        );

        -- Convert a std_logic_vector to a string
        FUNCTION to_string (inp : STD_LOGIC_VECTOR) RETURN STRING IS
            ALIAS vec : STD_LOGIC_VECTOR (1 TO inp'length) IS inp;
            VARIABLE result : STRING (vec'RANGE);
        BEGIN
            FOR i IN vec'RANGE LOOP
                result (i) := to_char (vec (i));
            END LOOP;
            RETURN result;
        END;

    BEGIN
        WAIT ON K, C_Int;
        IF (K'EVENT AND (K = '0' OR K = '1')) THEN
            -- Command Pipeline
            Cmnd_pipe (0) := Cmnd_pipe (1);
            Cmnd_pipe (1) := Cmnd_pipe (2);
            Cmnd_pipe (2) := 'X';

            -- Address Pipeline
            Addr_pipe (0) := Addr_pipe (1);
            Addr_pipe (1) := Addr_pipe (2);
            Addr_pipe (2) := (OTHERS => 'X');

            -- Internal Read Command
            IF (Cmnd_pipe (0) = '1') THEN
                Data_out_enable := '1';
                Addr_read_reg := Addr_pipe (0);
                Data_read_counter := 0;
                Burst_read_counter := '0';
            END IF;

            -- Data Out Register
            IF (Data_out_enable = '1') THEN
                -- Read Data Into Output Register
                Output_reg := Bank0 (CONV_INTEGER (Addr_read_reg & Burst_read_counter));

                -- Display Debug Message
                ASSERT (FALSE)
                    REPORT "Read  : SA = " & TO_STRING (Addr_read_reg & Burst_read_counter) & " - Q = " & TO_STRING (Output_reg)
                    SEVERITY NOTE;

                -- Increasement Counter
                Data_read_counter := Data_read_counter + 1;
                Burst_read_counter := NOT (Burst_read_counter);

                -- Reset
                IF (Data_read_counter >= 2 AND Data_out_enable = '1') THEN
                    Data_out_enable := '0';
                END IF;
            ELSE
                Output_reg := (OTHERS => 'Z');
            END IF;

            -- Latch External Command
            IF (K = '1') THEN
                IF (R_n = '0') THEN
                    Cmnd_pipe (2) := '1';
                    Addr_pipe (2) := SA;
                    -- Display Debug Message
                    ASSERT (FALSE)
                        REPORT "Read  : Command Detected"
                        SEVERITY NOTE;
                END IF;
                IF (W_n = '0') THEN
                    Data_in_enable := '1';
                    Input_buf := D;
                    Bw_reg := BW_n;
                    -- Display Debug Message
                    ASSERT (FALSE)
                        REPORT "Write : Command Detected"
                        SEVERITY NOTE;
                END IF;
            END IF;

            -- Data In Register
            IF (K = '0' AND Data_in_enable = '1') THEN
                -- First Write Data (latch data from posedge K)
                IF (Bw_reg (0) = '0' OR Bw_reg (1) = '0') THEN
                    -- Read Data Into Input Register
                    Input_reg := Bank0 (CONV_INTEGER(SA & '0'));
                    -- Perform BW# Operation
                    IF (Bw_reg (0) = '0') THEN
                        Input_reg (((data_bits / 2) - 1) DOWNTO 0) := Input_buf (((data_bits / 2) - 1) DOWNTO 0);
                    END IF;
                    IF (Bw_reg (1) = '0') THEN
                        Input_reg ((data_bits - 1) DOWNTO (data_bits / 2)) := Input_buf ((data_bits - 1) DOWNTO (data_bits / 2));
                    END IF;
                    -- Write Back to Memory
                    Bank0 (CONV_INTEGER(SA & '0')) := Input_reg;
                    -- Display Debug Message
                    ASSERT (FALSE)
                        REPORT "Write : SA = " & TO_STRING (SA & '0') & " - D = " & TO_STRING (Input_reg)
                        SEVERITY NOTE;
                END IF;
                
                -- Second Write Data
                IF (BW_n (0) = '0' OR BW_n (1) = '0') THEN
                    -- Read Data Into Input Register
                    Input_reg := Bank0 (CONV_INTEGER(SA & '1'));
                    -- Perform BW# Operation
                    IF (BW_n (0) = '0') THEN
                        Input_reg (((data_bits / 2) - 1) DOWNTO 0) := D (((data_bits / 2) - 1) DOWNTO 0);
                    END IF;
                    IF (BW_n (1) = '0') THEN
                        Input_reg ((data_bits - 1) DOWNTO (data_bits / 2)) := D ((data_bits - 1) DOWNTO (data_bits / 2));
                    END IF;
                    -- Write Back to Memory
                    Bank0 (CONV_INTEGER(SA & '1')) := Input_reg;
                    -- Display Debug Message
                    ASSERT (FALSE)
                        REPORT "Write : SA = " & TO_STRING (SA & '0') & " - D = " & TO_STRING (Input_reg)
                        SEVERITY NOTE;
                END IF;
                
                -- Reset
                Data_in_enable := '0';
            END IF;
        END IF;

        --Output Buffer
        IF (C_Int'EVENT AND (C_Int = '0' OR C_Int = '1')) THEN   
            Output_buf <= Output_reg;
        END IF; 
    END PROCESS main;

    -- Check for K Timing Violation
    K_check : PROCESS
        VARIABLE k_high, k_low : TIME := 0 ns;
    BEGIN
        WAIT ON K;
        IF K = '1' AND NOW >= tKHKH THEN
            ASSERT (NOW - k_low >= tKHKL)
                REPORT "K width low - tKHKL violation"
                SEVERITY ERROR;
            ASSERT (NOW - k_high >= tKHKH)
                REPORT "K period high - tKHKH violation"
                SEVERITY ERROR;
            k_high := NOW;
        ELSIF K = '0' AND NOW >= tKHKH THEN
            ASSERT (NOW - k_high >= tKLKH)
                REPORT "K width high - tKLKH violation"
                SEVERITY ERROR;
            ASSERT (NOW - k_low >= tKHKH)
                REPORT "K period low - tKHKH violation"
                SEVERITY ERROR;
            k_low := NOW;
        END IF;
    END PROCESS;

    -- Check for K# Timing Violation
    K_n_check : PROCESS
        VARIABLE k_n_high, k_n_low : TIME := 0 ns;
    BEGIN
        WAIT ON K_n;
        IF K_n = '1' AND NOW >= tKHKH THEN
            ASSERT (NOW - k_n_low >= tKHKL)
                REPORT "K# width low - tKHKL violation"
                SEVERITY ERROR;
            ASSERT (NOW - k_n_high >= tKHKH)
                REPORT "K# period high - tKHKH violation"
                SEVERITY ERROR;
            k_n_high := NOW;
        ELSIF K_n = '0' AND NOW >= tKHKH THEN
            ASSERT (NOW - k_n_high >= tKLKH)
                REPORT "K# width high - tKLKH violation"
                SEVERITY ERROR;
            ASSERT (NOW - k_n_low >= tKHKH)
                REPORT "K# period low - tKHKH violation"
                SEVERITY ERROR;
            k_n_low := NOW;
        END IF;
    END PROCESS;

    -- Check for C Timing Violation
    C_check : PROCESS
        VARIABLE c_high, c_low : TIME := 0 ns;
    BEGIN
        WAIT ON C;
        IF C = '1' AND NOW >= tKHKH THEN
            ASSERT (NOW - c_low >= tKHKL)
                REPORT "C width low - tKHKL violation"
                SEVERITY ERROR;
            ASSERT (NOW - c_high >= tKHKH)
                REPORT "C period high - tKHKH violation"
                SEVERITY ERROR;
            c_high := NOW;
        ELSIF C = '0' AND NOW >= tKHKH THEN
            ASSERT (NOW - c_high >= tKLKH)
                REPORT "C width high - tKLKH violation"
                SEVERITY ERROR;
            ASSERT (NOW - c_low >= tKHKH)
                REPORT "C period low - tKHKH violation"
                SEVERITY ERROR;
            c_low := NOW;
        END IF;
    END PROCESS;

    -- Check for C# Timing Violation
    C_n_check : PROCESS
        VARIABLE c_n_high, c_n_low : TIME := 0 ns;
    BEGIN
        WAIT ON C_n;
        IF C_n = '1' AND NOW >= tKHKH THEN
            ASSERT (NOW - c_n_low >= tKHKL)
                REPORT "C# width low - tKHKL violation"
                SEVERITY ERROR;
            ASSERT (NOW - c_n_high >= tKHKH)
                REPORT "C# period high - tKHKH violation"
                SEVERITY ERROR;
            c_n_high := NOW;
        ELSIF K_n = '0' AND NOW >= tKHKH THEN
            ASSERT (NOW - c_n_high >= tKLKH)
                REPORT "C# width high - tKLKH violation"
                SEVERITY ERROR;
            ASSERT (NOW - c_n_low >= tKHKH)
                REPORT "C# period low - tKHKH violation"
                SEVERITY ERROR;
            c_n_low := NOW;
        END IF;
    END PROCESS;

    -- Check for Setup Timing Violation
    setup_check : PROCESS
    BEGIN
        WAIT ON K;
        IF K = '1' THEN
            ASSERT (R_n'LAST_EVENT >= tAVKH)
                REPORT "R# - tIVKH violation"
                SEVERITY ERROR;
            ASSERT (W_n'LAST_EVENT >= tAVKH)
                REPORT "W# - tIVKH violation"
                SEVERITY ERROR;
            ASSERT (SA'LAST_EVENT >= tAVKH)
                REPORT "SA - tAVKH violation"
                SEVERITY ERROR;
            ASSERT (D'LAST_EVENT >= tAVKH)
                REPORT "D - tDVKH violation"
                SEVERITY ERROR;
        END IF;
    END PROCESS;

    -- Check for Hold Timing Violation
    hold_check : PROCESS
    BEGIN
        WAIT ON K'DELAYED(tKHIX), K'DELAYED(tKHAX), K'DELAYED(tKHDX);
        IF K'DELAYED(tKHIX) = '1' THEN
            ASSERT (R_n'LAST_EVENT > tKHIX)
                REPORT "R# - tKHIX violation"
                SEVERITY ERROR;
            ASSERT (W_n'LAST_EVENT > tKHIX)
                REPORT "W# - tKHIX violation"
                SEVERITY ERROR;
        END IF;
        IF K'DELAYED(tKHAX) = '1' THEN
            ASSERT (SA'LAST_EVENT > tKHAX)
                REPORT "SA - tKHAX violation"
                SEVERITY ERROR;
        END IF;
        IF K'DELAYED(tKHDX) = '1' THEN
            ASSERT (D'LAST_EVENT > tKHDX)
                REPORT "D - tKHDX violation"
                SEVERITY ERROR;
        END IF;
    END PROCESS;
END behave; 
