-----------------------------------------------------------------------
-- File:  PCK_CRC16_D64.vhd                              
-- Date:  Wed Nov 21 16:54:49 2001                                                      
--                                                                     
-- Copyright (C) 1999 Easics NV.                 
-- This source file may be used and distributed without restriction    
-- provided that this copyright statement is not removed from the file 
-- and that any derivative work contains the original copyright notice
-- and the associated disclaimer.
--
-- THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
-- OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
-- WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
--
-- Purpose: VHDL package containing a synthesizable CRC function
--   * polynomial: (0 2 15 16)
--   * data width: 64
--                                                                     
-- Info: jand@easics.be (Jan Decaluwe)                           
--       http://www.easics.com                                  
-----------------------------------------------------------------------


library IEEE;
use IEEE.std_logic_1164.all;

package PCK_CRC16_D64_CCITT is

  -- polynomial: (0 2 15 16)
  -- data width: 64
  -- convention: the first serial data bit is D(63)
  function nextCRC16_D64
    ( Data:  std_logic_vector(63 downto 0);
      CRC:   std_logic_vector(15 downto 0) )
    return std_logic_vector;

end PCK_CRC16_D64_CCITT;

