// renoir header_start
//
// Module FED_work.apvmux.behavioral
//
// Created:
//          by - wjfg72.UNKNOWN (TE2MANAGUA)
//          at - 15:53:24 13/11/00
//
// Generated by Mentor Graphics' Renoir(TM) 2000.3 (Build 2)
//
// renoir header_end

`resetall
`timescale 1ns/10ps
module apvmux1(clk, rstB, data, start, master, active_out, active_in, coladdr_in, coladdr_out, fault, enable);

parameter header_zero = 200;
parameter header_mag = 300;

input clk, rstB;
output [9:0] data;
output start;
input master, active_in;
output active_out;
output [7:0] coladdr_out;
input [7:0] coladdr_in;
input [3:0] fault;
input enable;

reg [6:0] tick_counter;
reg ticks;
reg [6:0] rand1;
always @(posedge clk or negedge rstB)
begin
	if (!rstB)
	begin
		tick_counter <= 0;
		ticks <= 0;
	end
	else
	begin
		rand1 <= #1 $random;
		if (tick_counter < 69)
		begin
			tick_counter <= tick_counter + 1;
		end
		else
		begin
			tick_counter <= 0;
		end
		if (tick_counter == 67) ticks <= 1;
		if (tick_counter == 69) ticks <= 0;
	end
end

reg [7:0] n;
wire [6:0] chan;
reg chip;
reg [1:0] packet;
reg active;
reg [15:0] delay;
reg [9:0] common_mode;
reg [7:0] column_addr;
integer rand;
always @(posedge clk or negedge rstB)
begin
	if (!rstB)
	begin
		active <= 0;
		delay <= 1;
		packet <= 2'b0;
   		n <= 7'b0;
		chip <= 1'b0;
		// rand = ($random % 100); common_mode <= 300 + (rand >= 0? rand : -rand);
		common_mode <= #1 $random;
		rand = ($random % 160); column_addr <= (rand >= 0? rand : -rand);
	end
	else
	begin
		if (enable)
		begin
			if (master)
			begin
				if (active)
				begin
					if (chip == 0)
					begin
						chip <= 1;
					end
					else
					begin
						chip <= 0;
						n <= n + 1;
						if (n == 138)
						begin
							// Uncomment one of the following lines to select the delay between frames
							//rand = ($random % 4); delay <= 44 + (rand >= 0? rand : -rand);  // this is for processed raw mode
							//rand = ($random % 4); delay <= (rand >= 0? rand : -rand);	// this is for other modes
							 delay = 0;   // this generates back to back events every 7us
						end
						if (n == 139)
						begin
							packet <= packet + 1;
							n <= 0;
							// rand = ($random % 100); common_mode <= 300 + (rand >= 0? rand : -rand);
							common_mode <= #1 $random;
							rand = ($random % 160); column_addr <= (rand >= 0? rand : -rand);
							if (delay != 0)
							begin
								active <= 0;
							end
						end
					end
				end
				else
				begin
					if (tick_counter == 67)
					begin
						if (delay == 0)
						begin
							active <= 1;
						end
						else
						begin
							delay = delay - 1;
						end
					end
				end
			end
			else
			begin
				if (active_in)
				begin
					if (chip == 0)
					begin
						chip <= 1;
					end
					else
					begin
						chip <= 0;
						n <= n + 1;
						if (n == 139)
						begin
							packet <= packet + 1;
							n <= 0;
							// rand = ($random % 100); common_mode <= 300 + (rand >= 0 ? rand : -rand);
							common_mode <= #1 $random;
							rand = ($random % 160); column_addr <= (rand >= 0 ? rand : -rand);
						end
					end
				end
			end
		end
	end
end

wire chip_real = (tick_counter[0]);
wire [7:0] n2 = (n - 12);
assign chan = {n2[1], n2[0], n2[3], n2[2], n2[6], n2[5], n2[4]};
wire active_real = ((fault != 12) ? (master ? active : active_in) : 1'b0);
wire [9:0] frame_data;
// assign frame_data = active_real ? {packet, chip, chan} : 10'h000;
// assign frame_data = active_real ? {packet, chip, rand1} : 10'h000;
assign frame_data = ((($random % 1000) == 0) ? 1023 : (common_mode + 25*(1 + ($random % 7))*(($random % 20) == 0) + 0*(($random % 41) - 20) + 20*chip));
wire [9:0] frame_data_real = (fault == 13) ? 600 - frame_data : frame_data;
wire [7:0] coladdr_real = (master ? column_addr : coladdr_in);
wire [7:0] coladdr1 = coladdr_real + (fault == 5) * (2 * ($random % 2) - 1);
wire [7:0] coladdr2 = coladdr_real + (fault == 6) * (2 * ($random % 2) - 1);
wire [7:0] coladdr3 = $random + packet; // 'packet' causes $random to update
wire [7:0] coladdr4 = $random + packet; // 'packet' causes $random to update
wire [11:0] header_data1 = {3'b111, ((fault != 11) ? coladdr1 : coladdr3), (fault != 9)};
wire [11:0] header_data2 = {3'b111, ((fault != 11) ? coladdr2 : coladdr4), (fault != 10)};
wire header = (!chip ? header_data1[11-n] : header_data2[11-n]);
wire [9:0] data_normal = (active_real ? ((n < 12) ? (header_zero + header_mag * header) : (frame_data_real)) :
				(header_zero + (header_mag + 0)*ticks)) + 0*((($random % 41) - 20) + 20*chip) + tick_counter*0;

reg [9:0] datareg1, datareg2;
always @(posedge clk)
begin
	if (!chip_real) datareg1 <= data_normal;
	if (chip_real)  datareg2 <= data_normal;
end
wire [9:0] data_r1 = ((fault != 2) ? ((fault != 7) ? data_normal : datareg1) : header_zero);
wire [9:0] data_r2 = ((fault != 3) ? ((fault != 8) ? data_normal : datareg2) : header_zero);
wire [9:0] data_real = (!chip_real ? data_r1 : data_r2);
reg [9:0] data_real2; always @(posedge clk) begin data_real2 <= data_real; end
wire [9:0] data_real3 = ((fault != 4) ? data_real : data_real2);

assign #1 data = ((fault != 1) ? data_real3 : header_zero);
assign #1 start = (active_real & (chip == 0) & (n == 0));
assign active_out = active;
assign coladdr_out = column_addr;

endmodule
								   	
