-- hds header_start
--
-- VHDL Architecture back_end_fpga.count_frame_cntl.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 15:20:24 03/31/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY count_frame_cntl IS
   PORT( 
      clk2x               : IN     std_logic;
      en_frm_cnt_dwn      : IN     std_logic;
      en_frm_cnt_up       : IN     std_logic;
      internal_freeze_bar : IN     std_logic;
      reset               : IN     std_logic;
      frm_cntr_clk_en     : OUT    std_logic;
      frm_cntr_up_dn      : OUT    std_logic
   );

-- Declarations

END count_frame_cntl ;

-- hds interface_end
ARCHITECTURE rtl OF count_frame_cntl IS
BEGIN
	process (reset, clk2x)
		variable cntr_clk_en_flag : std_logic;
		variable cntr_up_dn_flag : std_logic;
	begin
	if reset = '1' then
		cntr_clk_en_flag :=  '0';
		cntr_up_dn_flag :=  '0';
	else	
		if clk2x'event AND clk2x = '1' then		
			if (en_frm_cnt_dwn = '0' AND en_frm_cnt_up = '1' AND internal_freeze_bar = '1') then		-- write cycle
				cntr_clk_en_flag :=  '1';
				cntr_up_dn_flag :=  '1';
			elsif (en_frm_cnt_dwn = '1' AND en_frm_cnt_up = '0') then			-- read cycle
				cntr_clk_en_flag :=  '1';
				cntr_up_dn_flag :=  '0';
			else														-- any other condition (inc simultaneous rd & wr): do nothing
				cntr_clk_en_flag :=  '0';
				cntr_up_dn_flag :=  '0';
			end if;
		end if;
	end if;
	frm_cntr_clk_en <= cntr_clk_en_flag after 1 ns;
	frm_cntr_up_dn <= cntr_up_dn_flag after 1 ns;
	end process;
END rtl;
