-- hds header_start
--
-- VHDL Architecture back_end_fpga.up_down_cntr_antl.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 14:44:01 03/06/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY count_word_cntl IS
   PORT( 
      clk2x               : IN     std_logic;
      internal_freeze_bar : IN     std_logic;
      qdr_rd_addr_en      : IN     std_logic;
      qdr_wr_addr_en      : IN     std_logic;
      reset               : IN     std_logic;
      wrd_cntr_clk_en     : OUT    std_logic;
      wrd_cntr_up_dn      : OUT    std_logic
   );

-- Declarations

END count_word_cntl ;

-- hds interface_end
ARCHITECTURE rtl OF count_word_cntl IS
BEGIN
process (reset, clk2x)
	variable cntr_clk_en_flag : std_logic;
	variable cntr_up_dn_flag : std_logic;
begin
if reset = '1' then
	cntr_clk_en_flag :=  '0';
	cntr_up_dn_flag :=  '0';
elsif clk2x'event AND clk2x = '1' then	

	if (qdr_rd_addr_en = '0' AND qdr_wr_addr_en = '1' AND internal_freeze_bar = '1') then		-- write cycle only
		cntr_clk_en_flag :=  '1';							    -- enable write count up
		cntr_up_dn_flag :=  '1';
	
	elsif (qdr_rd_addr_en = '1' AND qdr_wr_addr_en = '0') then	-- read cycle only
		cntr_clk_en_flag :=  '1';						    -- enable read count down
		cntr_up_dn_flag :=  '0';

--	elsif (qdr_rd_addr_en = '1' AND qdr_wr_addr_en = '1' AND internal_freeze_bar = '0') then	-- read cycle when write is frozen
	elsif (qdr_rd_addr_en = '1' AND internal_freeze_bar = '0') then	-- read cycle when write is frozen
		cntr_clk_en_flag :=  '1';							    -- enable read count down
		cntr_up_dn_flag :=  '0';

	else						-- any other condition (inc simultaneous rd & wr): do nothing
		cntr_clk_en_flag :=  '0';
		cntr_up_dn_flag :=  '0';
	end if;
end if;		
wrd_cntr_clk_en <= cntr_clk_en_flag after 1 ns;
wrd_cntr_up_dn <= cntr_up_dn_flag after 1 ns;
end process;
END rtl;
