-- hds header_start
--
-- VHDL Architecture back_end_fpga.data_mux.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 09:20:15 01/20/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY data_mux IS
   PORT( 
      clk2x            : IN     std_logic;
      qdr_FE_data      : IN     std_logic_vector (71 DOWNTO 0);
      qdr_count_data   : IN     std_logic_vector (71 DOWNTO 0);
      qdr_test_data_en : IN     std_logic_vector (1 DOWNTO 0);
      qdr_test_pattern : IN     std_logic_vector (71 DOWNTO 0);
      reset            : IN     std_logic;
      qdr_wr_data      : OUT    std_logic_vector (71 DOWNTO 0)
   );

-- Declarations

END data_mux ;

-- hds interface_end
ARCHITECTURE rtl OF data_mux IS
BEGIN

process (reset, clk2x)
	begin
	if reset = '1' then
		qdr_wr_data <= (others => '0') after 1 ns;
	elsif clk2x'event and clk2x = '1' then
		if qdr_test_data_en = "01" then				-- select counting data to qdr
			qdr_wr_data <= qdr_count_data after 1 ns;
		elsif qdr_test_data_en = "10" then			-- select 5's and A's pattern data to qdr
			qdr_wr_data <= qdr_test_pattern after 1 ns;	
		else										
			qdr_wr_data <= qdr_FE_data after 1 ns;			-- any other condition use front end data
		end if;
	end if;
end process;

END rtl;
