-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.disabe_fifo_wr.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 12:59:33 11/15/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY disabe_fifo_wr IS
   PORT( 
      clk1x            : IN     std_logic;
      done_10          : IN     std_logic;
      reset            : IN     std_logic;
      total_length_int : IN     std_logic_vector (17 DOWNTO 0);
      done_11          : OUT    std_logic
   );

-- Declarations

END disabe_fifo_wr ;

-- hds interface_end
ARCHITECTURE rtl OF disabe_fifo_wr IS
BEGIN
	process (reset, clk1x)
		variable done_11_int : std_logic := '0';
	begin
		if reset = '1' then
		   done_11_int := '0';
		else
			if (clk1x'event AND clk1x = '1') then
				done_11_int := '0';
				if (done_10 = '1') then
					if (total_length_int = "000000000000000000") then
--						done_11_int := '0';		-- if length is zero, nothing is written to FIFO
						done_11_int := '1';		-- if length is zero, only one word is written to FIFO
					else
						done_11_int := '1';		-- if length is not zero, then total length and base addresses are written to FIFO.
					end if;
				end if;
		   end if;
		end if;
	done_11 <= done_11_int after 1 ns;
	end process;

END rtl;
