-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.end_addr_cntl.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 09:34:06 10/16/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

ENTITY end_addr_cntl IS
   PORT( 
      clk1x                   : IN     std_logic;
      done_2                  : IN     std_logic;
      end_addr_1              : IN     std_logic_vector (17 DOWNTO 0);
      reset                   : IN     std_logic;
      total_length_fifo_empty : IN     std_logic;
      base1                   : OUT    std_logic_vector (17 DOWNTO 0)
   );

-- Declarations

END end_addr_cntl ;

-- hds interface_end
ARCHITECTURE rtl OF end_addr_cntl IS
BEGIN

process (reset, clk1x)
	variable temp_addr_1 : unsigned (17 downto 0) := "000000000000000000";
begin
	if reset = '1' then
	   temp_addr_1 := (others =>'0');
	elsif (clk1x'event AND clk1x = '1') then
		if (done_2 = '1') then
			if total_length_fifo_empty = '1' then		-- if FIFO is empty then
				temp_addr_1 := (others =>'0');			-- addr zero is used
			else  										-- if FIFO is not empty
				temp_addr_1 := unsigned(end_addr_1);	-- convert end addr into unsigned
--				temp_addr_1 := temp_addr_1 + '1';		-- increment address
			end if;	
	   end if;
	end if;
	base1 <= std_logic_vector(temp_addr_1) after 1 ns;	-- assign to output as std_logic_vector
end process;

END rtl;
