-- hds header_start
--
-- VHDL Architecture cmm.sda_outmux.rtl
--
-- Created:
--          by - ipb28.UNKNOWN (TE2BELARUS)
--          at - 12:05:43 01/21/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;

ENTITY i2c_ttc_sda_out IS
   PORT( 
      data_to_ttc   : IN     std_logic_vector (7 DOWNTO 0);
      i2c_rd_nwr    : IN     std_logic;
      sel_pointer   : IN     std_logic;
      ttc_data_addr : IN     std_logic_vector (6 DOWNTO 0);
      ttc_pointer   : IN     std_logic_vector (4 DOWNTO 0);
      ttc_ptr_addr  : IN     std_logic_vector (6 DOWNTO 0);
      pda_out       : OUT    std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END i2c_ttc_sda_out ;

-- hds interface_end
--------------------------------------------------------------------------------
architecture rtl of i2c_ttc_sda_out is
--------------------------------------------------------------------------------
-- Load the S/R with address & 1 data byte
-- (data not transmitted for read operation).
-- Bit-swap each byte so MSB is tranmitted first:
--

--------------------------------------------------------------------------------
begin

  --
  --
--  muxproc: process (data_to_ttc, ttc_pointer, sel_pointer)
  muxproc: process (sel_pointer)
  begin
    if (sel_pointer = '1') then
	  -- writing to TTC pointer register:
      pda_out <= (
          -- byte 1:
          0 => ttc_ptr_addr(6),
          1 => ttc_ptr_addr(5),
          2 => ttc_ptr_addr(4),
          3 => ttc_ptr_addr(3),
          4 => ttc_ptr_addr(2),
          5 => ttc_ptr_addr(1),
          6 => ttc_ptr_addr(0),
          7 => '0', -- write
		  -- byte 2:
         10 downto 8 => '0',
         11 => ttc_pointer(4),
         12 => ttc_pointer(3),
         13 => ttc_pointer(2),
         14 => ttc_pointer(1),
         15 => ttc_pointer(0)   
      );	 
    else
	  -- writing/reading data....
      pda_out <= (
	      -- byte 1:
          0 => ttc_data_addr(6),
          1 => ttc_data_addr(5),
          2 => ttc_data_addr(4),
          3 => ttc_data_addr(3),
          4 => ttc_data_addr(2),
          5 => ttc_data_addr(1),
          6 => ttc_data_addr(0),
          7 => i2c_rd_nwr, 
		  -- byte 2:
          8 => data_to_ttc(7),
          9 => data_to_ttc(6),
         10 => data_to_ttc(5),
         11 => data_to_ttc(4),
         12 => data_to_ttc(3),
         13 => data_to_ttc(2),
         14 => data_to_ttc(1),
         15 => data_to_ttc(0)   
      );
	end if;
  end process;


end rtl;
