-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.inputDDR.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 16:10:16 09/24/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;


ENTITY inputDDR IS
   PORT( 
      clk  : IN     std_logic;
      data : IN     std_logic_vector (3 DOWNTO 0);
      rst  : IN     std_logic;
      Q    : OUT    std_logic_vector (7 DOWNTO 0);
      ce   : IN     std_logic
   );

-- Declarations

END inputDDR ;

-- hds interface_end
ARCHITECTURE rtl OF inputDDR IS

signal q1: std_logic_vector(3 DOWNTO 0):= (others => '0');
signal q2: std_logic_vector(3 DOWNTO 0):= (others => '0');
signal q3: std_logic_vector(3 DOWNTO 0):= (others => '0');

-- it is possible that the clks must be inverterd:
-- DDR transmits lsb on clk followed by msb on clk_n
-- therefore Rx must be:
-- rx lsb on clk_n followed by msb on clk
-- must test this code to get the functionality
-- 11/04/2003 @ 11:04am.

-- data from FE FPGA is msb (on falling clk) followed by lsb (on rising clk)

BEGIN

q1reg : process (clk,rst)
begin
	if rst='1' then 					      -- asynchronous reset, active high
--		q3 <= (others => '0');
		q1 <= (others => '0');				
	elsif clk'event and clk='0' then 	      -- Clock event - neg edge Get LSB
		if ce = '1' then					  -- chip enable = 1
			q1 <= data;					      -- store msb
		end if;
	end if;
end process;

q2reg : process (clk,rst)
begin
	if rst='1' then 					      -- asynchronous reset, active high
		q2 <= (others => '0');
		q3 <= (others => '0');
		Q <= (others => '0');
	elsif clk'event and clk='1' then   		-- Clock event - pos edge Get MSB
		if ce = '1' then					-- chip enable = 1
			q2 <= data;					    -- store lsb
			q3 <= q1;						-- get msb into q3 to be on same clk as lsb so it is not lost
			Q <= q2 & q3 after 1 ns;	  	
			-- this is q2 & q3 for the real IP to go into FPGA. Reverse for simulation
		end if;																				    
	end if;
end process;

END rtl;
