-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.length_decrement.rtl_1
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 11:13:56 10/11/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY length_decrement IS
   GENERIC( 
      denom : integer := 8
   );
   PORT( 
      d_length : IN     std_logic_vector (14 DOWNTO 0);	    -- number of data byte
      a_length : OUT    std_logic_vector (14 DOWNTO 0);	    -- number of 64-bit words of data
      clk      : IN     std_logic;
      en       : IN     std_logic;
      reset    : IN     std_logic
   );

-- Declarations

END length_decrement ;

-- hds interface_end
ARCHITECTURE rtl OF length_decrement IS
BEGIN
	process (reset, clk)
		variable tmp_qout : unsigned(14 downto 0) := "000000000000000";
		variable tmp_remain : unsigned(2 downto 0):= "000";
	    variable int_numer, int_remain :integer := 0;
    begin
		if reset = '1' then
			tmp_qout := (others => '0');
		elsif (clk'event and clk = '1') then
			if en = '1' then
--	shift right one bit = divide by 2 therefore shift right 3 bits = divide by 8
--  shift left one bit = multiply by 2
				int_numer := conv_integer(unsigned(d_length(14 downto 3)));  -- this is the number of 64-bit words of data
				int_remain := conv_integer(unsigned(d_length(2 downto 0)));  -- this is the remainder
				if (int_remain > 0) then
				 	int_numer := int_numer + 1;
				end if;
	 		 	tmp_qout := conv_unsigned(int_numer, 15);
			 	tmp_remain := conv_unsigned(int_remain, 3);
	 		 end if;
		end if;
	a_length <= "000" & std_logic_vector(tmp_qout) after 1 ns;
	-- remainder <= std_logic_vector(tmp_remain) after 1 ns;
    end process;                        
END rtl;
