-- hds header_start
--
-- VHDL Architecture CMS_FED.mux1to8.symbol
--
-- Created:
--          by - aas36.UNKNOWN (TE2WAITANGI)
--          at - 10:46:13 21/09/01
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2001.1 (Build 12)
--
-- hds header_end
LIBRARY ieee ;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.all;

ENTITY mux1to8 IS
   GENERIC( 
      widthin  : INTEGER := 8;
      widthout : INTEGER := 64
   );
   PORT( 
      clk      : IN     std_logic;
      din      : IN     std_logic_vector (widthin-1 DOWNTO 0);
      enable   : IN     std_logic;
      reset    : IN     std_logic;
      dout     : OUT    std_logic_vector (widthout-1 DOWNTO 0);
      dout_rdy : OUT    std_logic
   );

-- Declarations

END mux1to8 ;

-- hds interface_end
ARCHITECTURE behv OF mux1to8 IS
	type DWORD is array (7 downto 0) of std_logic_vector(widthin-1 downto 0);
	constant ZEROS : std_logic_vector(widthin-1 downto 0) := (others => '0');
	signal count : integer range 0 to 7 := 0;
begin
	process(clk, reset)
		variable dout_rdy_int : std_logic := '0';
		variable dout_int : std_logic_vector(widthout-1 downto 0);
		variable tmp_data : DWORD:= (others => ZEROS);
	begin
	   if (reset = '1') then
	     count 			<= 0;
		 dout_rdy_int 	:= '0';
	     dout_int 		:= ( others => '0');
	   else
	     if (clk'event and clk = '1') then
	       if (enable = '1')  then
	         if (count < 7) then		-- the 1st data is assigned to count = 0 , 2nd to count = 1 etc
	           tmp_data(count) := din;
	           count <= count + 1;
	         else
	           tmp_data(count) := din;	-- the last data is assigned to count = 7
	           count <= 0;
			   dout_rdy_int 	:= '1'; -- data is ready
	           dout_int := tmp_data(0)& tmp_data(1)& tmp_data(2)& tmp_data(3)& tmp_data(4)& tmp_data(5)& tmp_data(6)& tmp_data(7);
			   -- this ensures that 1st FE data received is at the msb position, and the 8th data byte is at lsb position within the word
	         end if;
		   else
	     		count 		<= 0;
		 		dout_rdy_int 	:= '0';
	     		dout_int 		:= ( others => '0');
	       end if;
	     end if;     
	   end if;
	dout_rdy 	<= dout_rdy_int after 1 ns;
	dout 		<= dout_int after 1 ns;
	end process;
END behv;
