-- hds header_start
--
-- VHDL Architecture VME_blockram.mux_1to9.rtl
--
-- Created:
--          by - ejf42.UNKNOWN (TE2BANGLADESH)
--          at - 09:46:54 02/21/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;


ENTITY mux_1to9_and_back IS
   PORT( 
      clk           : IN     std_logic;
      cmnd_in_a     : IN     std_logic;
      cmnd_in_b     : IN     std_logic;
      cmnd_in_c     : IN     std_logic;
      cmnd_in_d     : IN     std_logic;
      cmnd_in_e     : IN     std_logic;
      cmnd_in_f     : IN     std_logic;
      cmnd_in_g     : IN     std_logic;
      cmnd_in_h     : IN     std_logic;
      cmnd_in_i     : IN     std_logic;
      cmnd_in_j     : IN     std_logic;
      command_to_FE : IN     std_logic;
      en_mux_in     : IN     std_logic;
      rst           : IN     std_logic;
      selt          : IN     std_logic_vector (4 DOWNTO 0);
      cmnd_out_a    : OUT    std_logic;
      cmnd_out_b    : OUT    std_logic;
      cmnd_out_c    : OUT    std_logic;
      cmnd_out_d    : OUT    std_logic;
      cmnd_out_e    : OUT    std_logic;
      cmnd_out_f    : OUT    std_logic;
      cmnd_out_g    : OUT    std_logic;
      cmnd_out_h    : OUT    std_logic;
      cmnd_out_i    : OUT    std_logic;
      cmnd_out_j    : OUT    std_logic;
      data_from_FE1 : OUT    std_logic
   );

-- Declarations

END mux_1to9_and_back ;

-- hds interface_end
ARCHITECTURE rtl OF mux_1to9_and_back IS
BEGIN
process (clk,rst)
begin
if rst = '1' then
	cmnd_out_a <= '0';
	cmnd_out_b <= '0';
	cmnd_out_c <= '0';
	cmnd_out_d <= '0';
	cmnd_out_e <= '0';
	cmnd_out_f <= '0';
	cmnd_out_g <= '0';
	cmnd_out_h <= '0';
	cmnd_out_i <= '0';
	cmnd_out_j <= '0';
	data_from_FE1 <= '0';    -- data from FE FPGA to vme FPGA ie used for read back

elsif clk'event and clk = '1' then

	if en_mux_in = '1' then

		case selt is 


			when "00001" =>
				cmnd_out_a <= command_to_FE;
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_a;

			when "00010" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= command_to_FE;
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_b;

			when "00011" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= command_to_FE;
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_c;

			when "00100" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= command_to_FE;
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_d;

			when "00101" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= command_to_FE;
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_e;

			when "00110" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= command_to_FE;
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_f;

			when "00111" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= command_to_FE;
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_g;

			when "01000" => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= command_to_FE;
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_h;

			when "01001" => 	  -- Test
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= command_to_FE;
				cmnd_out_j <= '0';
				data_from_FE1 <= cmnd_in_i;

			when "01010" => 	   -- Back End FPGA
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				cmnd_out_j <= command_to_FE;
				data_from_FE1 <= cmnd_in_j;


			when "01111" => 					-- broadcast to all FE FPGAs
				cmnd_out_a <= command_to_FE;
				cmnd_out_b <= command_to_FE;
				cmnd_out_c <= command_to_FE;
				cmnd_out_d <= command_to_FE;
				cmnd_out_e <= command_to_FE;
				cmnd_out_f <= command_to_FE;
				cmnd_out_g <= command_to_FE;
				cmnd_out_h <= command_to_FE;
				cmnd_out_i <= '0';
				cmnd_out_j <= '0';
				data_from_FE1 <= '0';


			when others => 
				cmnd_out_a <= '0';
				cmnd_out_b <= '0';
				cmnd_out_c <= '0';
				cmnd_out_d <= '0';
				cmnd_out_e <= '0';
				cmnd_out_f <= '0';
				cmnd_out_g <= '0';
				cmnd_out_h <= '0';
				cmnd_out_i <= '0';
				data_from_FE1 <= '0';

		  end case;
		
		
		
		else  
		  
	  		cmnd_out_a <= '0';
	  		cmnd_out_b <= '0';
	  		cmnd_out_c <= '0';
	  		cmnd_out_d <= '0';
	  		cmnd_out_e <= '0';
	  		cmnd_out_f <= '0';
	  		cmnd_out_g <= '0';
	  		cmnd_out_h <= '0';
	  		cmnd_out_i <= '0';
			data_from_FE1 <= '0';
		  
		  
		  
		  
		  
		  
		end if;	  
 	end if;
end process;
END rtl;
