-- hds header_start
--
-- VHDL Architecture back_end_fpga.qdr_flags_gen.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 11:18:50 08/04/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY qdr_flags_gen IS
   PORT( 
      clk2x          : IN     std_logic;
      qdr_data_count : IN     std_logic_vector (17 DOWNTO 0);
      reset          : IN     std_logic;
      qdr_25_flag    : OUT    std_logic;
      qdr_50_flag    : OUT    std_logic;
      qdr_87_flag    : OUT    std_logic;
      qdr_empty_flag : OUT    std_logic;
      qdr_full_flag  : OUT    std_logic
   );

-- Declarations

END qdr_flags_gen ;

-- hds interface_end
ARCHITECTURE rtl OF qdr_flags_gen IS
BEGIN
Process (clk2x, reset)
	begin
	if reset = '1' then
		qdr_full_flag <= '0';
		qdr_87_flag <= '0';
		qdr_50_flag <= '0';
		qdr_25_flag <= '0';
		qdr_empty_flag <= '1';
	elsif clk2x'event AND clk2x = '1' then
		if conv_integer(qdr_data_count) > 262140 then  		--  full
			qdr_full_flag <= '1' after 1 ns;
			qdr_87_flag <= '1' after 1 ns;
			qdr_50_flag <= '1' after 1 ns;
			qdr_25_flag <= '1' after 1 ns;
			qdr_empty_flag <= '0' after 1 ns;
		elsif conv_integer(qdr_data_count) > 229376 then  	-- 87% full  $38000
			qdr_full_flag <= '0' after 1 ns;
			qdr_87_flag <= '1' after 1 ns;
			qdr_50_flag <= '1' after 1 ns;
			qdr_25_flag <= '1' after 1 ns;
			qdr_empty_flag <= '0' after 1 ns;
		elsif conv_integer(qdr_data_count) > 131072 then  	-- 50% full  $20000
			qdr_full_flag <= '0' after 1 ns;
			qdr_87_flag <= '0' after 1 ns;
			qdr_50_flag <= '1' after 1 ns;
			qdr_25_flag <= '1' after 1 ns;
			qdr_empty_flag <= '0' after 1 ns;
		elsif conv_integer(qdr_data_count) > 65536 then  	-- 25% full  $10000
			qdr_full_flag <= '0' after 1 ns;
			qdr_87_flag <= '0' after 1 ns;
			qdr_50_flag <= '0' after 1 ns;
			qdr_25_flag <= '1' after 1 ns;
			qdr_empty_flag <= '0' after 1 ns;
		elsif qdr_data_count = "000000000000000000" then   	-- empty
			qdr_full_flag <= '0' after 1 ns;
			qdr_87_flag <= '0' after 1 ns;
			qdr_50_flag <= '0' after 1 ns;
			qdr_25_flag <= '0' after 1 ns;
			qdr_empty_flag <= '1' after 1 ns;
		else   									-- memory is not empty
			qdr_full_flag <= '0' after 1 ns;
			qdr_87_flag <= '0' after 1 ns;
			qdr_50_flag <= '0' after 1 ns;
			qdr_25_flag <= '0' after 1 ns;
			qdr_empty_flag <= '0' after 1 ns;
		end if;
	end if;	
end process;
END rtl;
