-- hds header_start
--
-- VHDL Architecture back_end_fpga.rd_add_one.rtl_rd_throttle
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 10:00:58 03/04/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY rd_add_one IS
   PORT( 
      clk2x            : IN     std_logic;
      rd_base_addr     : IN     std_logic_vector (17 DOWNTO 0);
      rd_base_int      : IN     std_logic_VECTOR (17 DOWNTO 0);
      rd_frm_data_1    : IN     STD_ULOGIC;
      rd_load_or_count : IN     std_logic;
      reset            : IN     std_logic;
      rd_base_1        : OUT    std_logic_VECTOR (17 DOWNTO 0)
   );

-- Declarations

END rd_add_one ;

-- hds interface_end
ARCHITECTURE rtl_rd_throttle OF rd_add_one IS
BEGIN
process (reset, clk2x)
	variable base_temp : unsigned (17 downto 0);
begin
	if reset = '1' then
		base_temp := (others => '0');
	elsif clk2x'event AND clk2x = '1' then
		if rd_load_or_count = '1' then					-- if in load mode
			base_temp := unsigned(rd_base_addr);		-- put read base address out
		else											-- if in count mode
			if rd_frm_data_1 = '1' then					-- and operation is enabled
				base_temp := unsigned(rd_base_int);		-- then work out next address
				base_temp := base_temp + 1;				-- and increment the base by one 
			end if;
		end if;
	end if;
	rd_base_1 <= std_logic_vector (base_temp) after 1 ns;	 -- push out new base onto shift register
	end process;
END rtl_rd_throttle;
