-- hds header_start
--
-- VHDL Architecture back_end_fpga.rd_decrement_one.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 11:45:43 03/26/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY rd_decrement_one IS
   PORT( 
      clk2x                  : IN     std_logic;
      rd_frm_cnt_en          : IN     STD_ULOGIC;
      rd_length_int          : IN     std_logic_vector (17 DOWNTO 0);
      rd_load_or_count       : IN     std_logic;
      rd_total_length        : IN     std_logic_vector (17 DOWNTO 0);
      read_throttle_B        : IN     std_logic;
      reset                  : IN     std_logic;
      last_wrd_mask_throttle : OUT    std_logic;
      rd_frm_data_1          : OUT    STD_ULOGIC;
      rd_length_1            : OUT    std_logic_vector (17 DOWNTO 0)
   );

-- Declarations

END rd_decrement_one ;

-- hds interface_end
ARCHITECTURE rtl OF rd_decrement_one IS


BEGIN
process (reset, clk2x)
	variable frame_flag : std_logic;
	variable length_temp : unsigned (17 downto 0);
	begin
	if reset = '1' then
		length_temp := (others => '0');
		frame_flag := '0';
	elsif clk2x'event AND clk2x = '1' then
		if rd_load_or_count = '1' then					-- if in load mode
			length_temp := unsigned(rd_total_length);	-- put read address out
			frame_flag := '1';							-- set read data flag to '1' for data to be read from QDR.
		elsif rd_frm_cnt_en = '1' then					-- if in count mode and operation is enabled
			length_temp := unsigned(rd_length_int);		-- then work out new length
			if length_temp = 1 then						-- if length is one, then this is last data so stop reading.
				frame_flag := '0';						-- all data has been stored
				length_temp := (others => '0');			--  push out length zero onto shift register
			else										-- if length is not zero, then read data
				length_temp := length_temp - 1;			-- and decrement the length by one 
				frame_flag := '1';						-- '1' means read data, as there is still data to be read from QDR.
			end if;
		end if;
	end if;
	rd_length_1 <= std_logic_vector (length_temp) after 1 ns;	 -- push out new length onto shift register
	rd_frm_data_1 <= frame_flag after 1 ns;
	end process;

END rtl;
