-- hds header_start
--
-- VHDL Architecture back_end_fpga.rd_fe_len_flag_gen.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 12:13:55 03/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY rd_fe_len_flag_gen IS
   PORT( 
      clk2x           : IN     std_logic;
      rd_fe_len_flags : IN     std_logic_vector (2 DOWNTO 0);
      reset           : IN     std_logic;
      fe_len_25_flag  : OUT    std_logic;
      fe_len_50_flag  : OUT    std_logic;
      fe_len_87_flag  : OUT    std_logic
   );

-- Declarations

END rd_fe_len_flag_gen ;

-- hds interface_end
ARCHITECTURE rtl OF rd_fe_len_flag_gen IS
BEGIN
Process (clk2x, reset)
	begin
	if reset = '1' then
		fe_len_87_flag <= '0' after 1 ns;
		fe_len_50_flag <= '0' after 1 ns;
		fe_len_25_flag <= '0' after 1 ns;
	elsif clk2x'event AND clk2x = '1' then
		if conv_integer(rd_fe_len_flags) > 6 then  		-- 87% full
			fe_len_87_flag <= '1' after 1 ns;
			fe_len_50_flag <= '1' after 1 ns;
			fe_len_25_flag <= '1' after 1 ns;
		elsif conv_integer(rd_fe_len_flags) > 3 then  		-- 50% full
			fe_len_87_flag <= '0' after 1 ns;
			fe_len_50_flag <= '1' after 1 ns;
			fe_len_25_flag <= '1' after 1 ns;
		elsif conv_integer(rd_fe_len_flags) > 1 then  		-- 25% full
			fe_len_87_flag <= '0' after 1 ns;
			fe_len_50_flag <= '0' after 1 ns;
			fe_len_25_flag <= '1' after 1 ns;
		else   										-- memory is not empty
			fe_len_87_flag <= '0' after 1 ns;
			fe_len_50_flag <= '0' after 1 ns;
			fe_len_25_flag <= '0' after 1 ns;
		end if;
	end if;	
end process;
END rtl;
