-- hds header_start
--
-- VHDL Architecture back_end_fpga.rdout_mux8to2.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 16:32:07 02/25/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY rdout_mux8to1 IS
   GENERIC( 
      widthout : integer := 64
   );
   PORT( 
      clk2x    : IN     std_logic;
      dout1    : IN     std_logic_vector (63 DOWNTO 0);
      dout2    : IN     std_logic_vector (63 DOWNTO 0);
      dout3    : IN     std_logic_vector (63 DOWNTO 0);
      dout4    : IN     std_logic_vector (63 DOWNTO 0);
      dout5    : IN     std_logic_vector (63 DOWNTO 0);
      dout6    : IN     std_logic_vector (63 DOWNTO 0);
      dout7    : IN     std_logic_vector (63 DOWNTO 0);
      dout8    : IN     std_logic_vector (63 DOWNTO 0);
      dout_rdy : IN     std_logic;
      reset    : IN     std_logic;
      fe_data  : OUT    std_logic_vector (63 DOWNTO 0)
   );

-- Declarations

END rdout_mux8to1 ;

-- hds interface_end
ARCHITECTURE rtl OF rdout_mux8to1 IS
	type temp is array (0 to 7) of std_logic_vector (widthout-1 downto 0);
	constant zeros : std_logic_vector (widthout-1 downto 0):= (others => '0');
--	signal count : integer range 0 to 7;
BEGIN
	process (clk2x, reset)
		variable fe_data_int : std_logic_vector (widthout-1 downto 0);
		variable data_int : temp := (others => zeros);
		variable count : integer range 0 to 7;
	begin
		if (reset = '1') then
			fe_data_int := zeros;
			count := 0;
		elsif (clk2x'event and clk2x = '1') then
			if (dout_rdy = '1') then			-- if data is ready
				if (count = 0) then
					data_int := (dout1, dout2, dout3, dout4, dout5, dout6, dout7, dout8);	-- assign data to array
					fe_data_int := data_int(count);		-- assign relevant array cell (0 to 7) to output
					count := count + 1;					-- add one to count for next cell
				else
					if (count = 7) then
						fe_data_int := data_int(count);	-- assign relevant array cell (0 to 7) to output
						count := 0;						-- if equal to 7, just assign data to array and reset count
					else
						fe_data_int := data_int(count);	-- assign relevant array cell (0 to 7) to output
						count := count + 1;				-- add one to count for next cell
					end if;
				end if;
			else
				count := 0;
				fe_data_int := (others => '0');
			end if;
		end if;
	fe_data <= fe_data_int after 1 ns;	-- assign to output
	end process;
END rtl;
