-- hds header_start
--
-- VHDL Architecture back_end_fpga.rdout_mux8to1.rtl_case
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 14:04:46 04/07/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY rdout_mux8to1 IS
   GENERIC( 
      widthout : integer := 64
   );
   PORT( 
      clk2x    : IN     std_logic;
      dout1    : IN     std_logic_vector (63 DOWNTO 0);
      dout2    : IN     std_logic_vector (63 DOWNTO 0);
      dout3    : IN     std_logic_vector (63 DOWNTO 0);
      dout4    : IN     std_logic_vector (63 DOWNTO 0);
      dout5    : IN     std_logic_vector (63 DOWNTO 0);
      dout6    : IN     std_logic_vector (63 DOWNTO 0);
      dout7    : IN     std_logic_vector (63 DOWNTO 0);
      dout8    : IN     std_logic_vector (63 DOWNTO 0);
      dout_rdy : IN     std_logic;
      reset    : IN     std_logic;
      fe_data  : OUT    std_logic_vector (63 DOWNTO 0)
   );

-- Declarations

END rdout_mux8to1 ;

-- hds interface_end
ARCHITECTURE rtl_case OF rdout_mux8to1 IS
	signal count : integer := 0;
BEGIN
	process (clk2x, reset)
		variable fe_data_int : std_logic_vector (widthout-1 downto 0);
	begin
		if (reset = '1') then
			fe_data_int := (others => '0');
			count <= 0;
		elsif (clk2x'event and clk2x = '1') then
			if (dout_rdy = '1') then			-- if data is ready
				count <= (count + 1);
				case count is 
					when 1 =>
						fe_data_int := dout1;
					when 2 =>
						fe_data_int := dout2;
					when 3 =>
						fe_data_int := dout3;
					when 4 =>
						fe_data_int := dout4;
					when 5 =>
						fe_data_int := dout5;
					when 6 =>
						fe_data_int := dout6;
					when 7 =>
						fe_data_int := dout7;
					when 8 =>
						fe_data_int := dout8;
						count <= 0;
--					when 9 =>
--						count <= 0;
					when others =>
						fe_data_int := (others => '0');
						count <= 0;
				end case;
			else 
				count <= 0;
				fe_data_int := (others => '0');
			end if;
		end if;
	fe_data <= fe_data_int after 1 ns;	-- assign to output
	end process;
END rtl_case;
