-- hds header_start
--
-- VHDL Architecture back_end_fpga.sel_FE_trig_cntl.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 14:42:48 07/22/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.numeric_std.ALL;
USE ieee.std_logic_unsigned.all;

ENTITY sel_FE_trig_cntl IS
   PORT( 
      clk1x           : IN     std_logic;
      en_trigger      : IN     std_logic;
      reset           : IN     std_logic;
      sel_trig_source : IN     std_logic_vector (2 DOWNTO 0);
      sw_trigger      : IN     std_logic;
      test_trig_sig   : IN     std_logic;
      ttc_L1_accept   : IN     std_logic;
      L1_accept_int   : OUT    std_logic
   );

-- Declarations

END sel_FE_trig_cntl ;

-- hds interface_end
ARCHITECTURE rtl OF sel_FE_trig_cntl IS
BEGIN
Process (reset, clk1x)
	begin
	if reset = '1' then
		L1_accept_int <= '0' after 1 ns;
	elsif clk1x'event and clk1x = '1' then
		if en_trigger = '1'  then
			if sel_trig_source = "001" then
				L1_accept_int <= ttc_L1_accept after 1 ns;		-- assign TTC input to trigger decode for the FE FPGAs
			elsif sel_trig_source = "010" then	
				L1_accept_int <= test_trig_sig after 1 ns;	-- assign backplane input to trigger decode for the FE FPGAs
			elsif sel_trig_source = "100" then	
				L1_accept_int <= sw_trigger after 1 ns;	-- assign software input to trigger decode for the FE FPGAs
			else
				L1_accept_int <= '0' after 1 ns;
		 	end if;
		else
			L1_accept_int <= '0' after 1 ns;
		end if;
	end if;
end process;
END rtl;
