-- hds header_start
--
-- VHDL Architecture back_end_fpga.throttle_select.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 10:56:45 11/04/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY throttle_select IS
   PORT( 
      clk2x                : IN     std_logic;
      en_qdr_data_to_slink : IN     std_logic;
      en_qdr_data_to_vme   : IN     std_logic;
      rst                  : IN     std_logic;
      slink_ldown_b        : IN     std_logic;
      slink_lff_b          : IN     std_logic;
      vme_throttle         : IN     std_logic;
      int_throttle         : OUT    std_logic
   );

-- Declarations

END throttle_select ;

-- hds interface_end
ARCHITECTURE rtl OF throttle_select IS
BEGIN


process(clk2x, rst)
begin
	if rst = '1' then
		int_throttle <= '0' ;
	elsif clk2x'event AND clk2x = '1' then
		if en_qdr_data_to_slink = '1' and en_qdr_data_to_vme = '0' then		-- choose SLINK throttle
			int_throttle <= (slink_lff_b AND slink_ldown_b) after 1 ns;		-- slink_throttle is active low signal combined with link down signal
		elsif en_qdr_data_to_slink = '0' and en_qdr_data_to_vme = '1' then	-- choose VME throttle
			int_throttle <= NOT(vme_throttle) after 1 ns;			    	-- vme_throttle is active high signal
		else
			int_throttle <= '0' after 1 ns;
		end if;
	end if;
end process;
END rtl;
