//  STIM 1  for test
//
// Module chan_twelve.stimulus1.functional
//
// Created:
//          by - wjfg72.UNKNOWN (TE2MANAGUA)
//          at - 11:32:20 11/04/01
//
// Generated by Mentor Graphics' Renoir(TM) 2000.3 (Build 2)
//
// renoir header_end

`resetall
`timescale 1ns/1ps
`include "D:/Xilinx/verilog/src/glbl.v"
// clock 40 MHz
`define per 25	    
`define high 12.5
`define low 12.5

`define load_skew 1
`define load_tick 2
`define load_thresh 4
`define spy_arm 7
`define spy_fire 8
`define load_median 10
`define set_median_enable 11
`define soft_rst 12
`define load_peddata 13
`define load_pedaddr 14
`define load_numval 15
`define load_mode_reg 16
`define load_scope_length 17
`define monitor 20
`define cdc_thru 21
`define opto_control 22
`define adc_control 23
`define vref_control 24
`define lm82_control 25
`define load_complement 26
`define fe_disable_reg 5


//these are designator values in decimal
`define trigger_select	1	// trigger select reg
`define mode_reg		2	// mode select register
`define ttc_rx_i2c		3	// TTCrx I2C interface
`define apv_frame_reg	4 	//APV Frame Register
`define be_rdout_cntl	6	// back end read out control
`define be_run_cntl		7	// back end run control
`define sw_trigger		8	// software trigger
`define fed_id_reg		10	// FED ID register set by software

`define be_status_reg	16	// Back end status register
`define rd_L1A_count	17	// read L1A counter
`define rd_bx_count		18	// read bunch crossing counter
`define qdr_frame_count	19	// read QDR frame counter
`define TTC_status_reg	20	// read TTC status register 
`define firmware_id_reg	21	// read firmware ID reg read only = UserCode



module toplevel_twelve_stim1( 
   c1_fault, c2_fault, c3_fault, c4_fault, c5_fault, c6_fault, c7_fault, c8_fault, c9_fault, c10_fault, c11_fault, c12_fault, 
   clk, clkB, rstB, serial_in, readout_synch_out, frame_synch_out, enable_apvmux);

parameter DESIGNATOR = 5; // Number of bits in Command Designator
parameter LENGTH_FIELD = 16; // Number of bits in Command Length

// Internal Declarations

output [3:0]  c10_fault;
output [3:0]  c11_fault;
output [3:0]  c12_fault;
output [3:0]  c1_fault;
output [3:0]  c2_fault;
output [3:0]  c3_fault;
output [3:0]  c4_fault;
output [3:0]  c5_fault;
output [3:0]  c6_fault;
output [3:0]  c7_fault;
output [3:0]  c8_fault;
output [3:0]  c9_fault;
output        clk;
output        clkB;
output        rstB;
output        serial_in;
output        readout_synch_out;
output frame_synch_out;
output enable_apvmux;

reg [3:0]  c10_fault;
reg [3:0]  c11_fault;
reg [3:0]  c12_fault;
reg [3:0]  c1_fault;
reg [3:0]  c2_fault;
reg [3:0]  c3_fault;
reg [3:0]  c4_fault;
reg [3:0]  c5_fault;
reg [3:0]  c6_fault;
reg [3:0]  c7_fault;
reg [3:0]  c8_fault;
reg [3:0]  c9_fault;
reg        clk;
reg        rstB;
reg        serial_in;
reg        readout_synch_out;
reg frame_synch_out;
reg enable_apvmux;
integer a, b;

always
begin
	#`high	clk = 0;
	#`low	clk = 1;
end

assign clkB = !clk;

/////////////////////////////////////////////////
//    THIS IS THE BEGINNING OF THE STIMULUS    //
/////////////////////////////////////////////////
initial
begin
	set_defaults;
	stimulus2;		    
end
/////////////////////////////////////////////////

task set_defaults;
begin
	clk = 1;
	rstB = 0;
	c1_fault = 0; c2_fault = 0; c3_fault = 0; c4_fault = 0;
	c5_fault = 0; c6_fault = 0; c7_fault = 0; c8_fault = 0;
	c9_fault = 0; c10_fault = 0; c11_fault = 0; c12_fault = 0;
	serial_in = 0; readout_synch_out = 0;
	frame_synch_out = 0; enable_apvmux = 0;
end
endtask


task stimulus1;   // test the delay fpga spy data
begin
	#2 ;
	#`per	;
	#(200*`per)	rstB = 1; // Long reset to allow time for DCM to settle

	// set mode of operation

	serial_out(2, 2);
 	serial_out(DESIGNATOR, `load_mode_reg);
	serial_out(1, 1);
	serial_out(LENGTH_FIELD, 5);		// Length
	serial_out(1, 0);						// procraw_mode
	serial_out(1, 0);						// zerosupp_mode
	serial_out(1, 1);						// virgraw_mode
	serial_out(1, 0);						// frame_finding
	serial_out(1, 1);						// scope_mode
	serial_out(10, 0);					    // Set serial_in low


	#(10 * `per);
	serial_out(2, 2); 
	serial_out(DESIGNATOR, `load_scope_length);
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 10);		// Length
	serial_out(10, 256);					// scope_length	     
	serial_out(10, 0);					// Set serial_in low

	// arm spy channel
	serial_out(2, 2); 					  // send "10"
	serial_out(DESIGNATOR, `cdc_thru);	  // command to delay fpga
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 28);		// Length = 28 (to arm, the cmnd to dly fpga is 28 bits long)
	serial_out(1, 1);						// header
	serial_out(2, 3);						// chip number  , chip 3 ie all channels
	serial_out(1, 1);						// header
	serial_out(1, 0);						// header
	serial_out(5, `spy_arm);				// spy arm designator
	serial_out(1, 1);						// header
	serial_out(LENGTH_FIELD, 1);			// send length of 1
	serial_out(1, 1);						// set spy arm to 1
	serial_out(10, 0);					// Set serial_in low
	#(1200 * `per);

	// fire spy channel
	serial_out(2, 2); 					  // send "10"
	serial_out(DESIGNATOR, `cdc_thru);	  // command to delay fpga
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 128);		// Length = 28 (to arm, the cmnd to dly fpga is 28 bits long)& 100 for data
	serial_out(1, 1);						// header
	serial_out(2, 0);						// chip number  , chip 0 ie first fpga
	serial_out(1, 1);						// header
	serial_out(1, 0);						// header
	serial_out(5, `spy_fire);				// spy fir designator
	serial_out(1, 1);						// header
	serial_out(LENGTH_FIELD, 100);			// send length of 100
	serial_out(1, 0);						// set spy arm to 1
	serial_out(10, 0);					// Set serial_in low


	#(50 * `per)	enable_apvmux = 1;
//	#(5 * `per);
	#`per			frame_synch_out = 1;
	#`per			frame_synch_out = 0;

	#(150 * `per);
	#`per			frame_synch_out = 1;
	#`per			frame_synch_out = 0;
	
	#(500 * `per)	readout_synch_out = 1;
	#`per			readout_synch_out = 0;

	#(3000 * `per)	readout_synch_out = 1;
	#`per			readout_synch_out = 0;

end
endtask


task stimulus2;
// This one tests the FPGA in scope mode
begin
	#2 ;
	#`per	;
	#(180*`per)	rstB = 1; // Long reset to allow time for DCM to settle

	serial_out(2, 2);
 	serial_out(DESIGNATOR, `load_mode_reg);
	serial_out(1, 1);
	serial_out(LENGTH_FIELD, 5);		// Length
	serial_out(1, 0);						// procraw_mode
	serial_out(1, 0);						// zerosupp_mode
	serial_out(1, 1);						// virgraw_mode
	serial_out(1, 0);						// frame_finding
	serial_out(1, 1);						// scope_mode
	serial_out(10, 0);					    // Set serial_in low

	serial_out(2, 2); 
	serial_out(DESIGNATOR, `load_scope_length);
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 10);		// Length
	serial_out(10, 2);					// scope_length	     
	serial_out(10, 0);					// Set serial_in low

	#(150 * `per)	enable_apvmux = 1;

	#`per			frame_synch_out = 1;
	#`per			frame_synch_out = 0;

	#(250 * `per);
	#`per			frame_synch_out = 1;
	#`per			frame_synch_out = 0;
	
	#(700 * `per)	readout_synch_out = 1;
	#`per			readout_synch_out = 0;

	#(3000 * `per)	readout_synch_out = 1;
	#`per			readout_synch_out = 0;

end
endtask


task set_registers;
begin
	serial_out(2, 2); serial_out(DESIGNATOR, `load_thresh);
	serial_out(1, 1); serial_out(LENGTH_FIELD, 60);	// Length
	serial_out(5, 12);					    // threshold1
	serial_out(5, 13);					    // threshold2
	serial_out(5, 12);					    // threshold3
	serial_out(5, 13);					    // threshold4
	serial_out(5, 12);					    // threshold5
	serial_out(5, 13);					    // threshold6
	serial_out(5, 12);					    // threshold7
	serial_out(5, 13);					    // threshold8
	serial_out(5, 12);					    // threshold9
	serial_out(5, 13);					    // threshold10
	serial_out(5, 12);					    // threshold11
	serial_out(5, 13);					    // threshold12
	serial_out(10, 0);					    // Set serial_in low
end
endtask


task serial_out;
input [15:0] length;
input [65535:0] value;
integer a;
begin
	for (a = length; a > 0; a = a - 1)
	begin
		serial_in = value[a-1];
		#`per;
	end
end
endtask


task stimulus3;
// This one side-steps the autocal procedure (saves time).
// Thereafter anything you like.
begin
	#2 ;
	#`per	;
	#(30*`per)	rstB = 1; // Long reset to allow time for DCM to settle

	#(100 * `per);
	serial_out(1, 1); 			// set 1st bit to 1 = header
	serial_out(1, 0); 			// set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `trigger_select);	// wr trigger_select	 
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 3);	// Length
	serial_out(1, 1);						
	serial_out(1, 0);						
	serial_out(1, 0);						
	serial_out(10, 0);			// Set serial_in low

	#(100 * `per);
	serial_out(1, 1); 			// set 1st bit to 1 = header
	serial_out(1, 0); 			// set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `mode_reg);	// wr mode_reg	 
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 4);	// Length
	serial_out(1, 0);				//Scope mode			
	serial_out(1, 0);
	serial_out(1, 0);
	serial_out(1, 1);
	serial_out(10, 0);				// Set serial_in low

	#(100 * `per);
	serial_out(1, 1); 			// set 1st bit to 1 = header
	serial_out(1, 0); 			// set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `ttc_rx_i2c);	// wr ttc_rx_i2c	 
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 2);	// Length
	serial_out(1, 1);						
	serial_out(1, 1);						
	serial_out(10, 0);			// Set serial_in low

	#(100 * `per);
	serial_out(1, 1); 			// set 1st bit to 1 = header
	serial_out(1, 0); 			// set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `apv_frame_reg);	// wr apv_frame_reg	 
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 1);	// Length
	serial_out(1, 1);						
	serial_out(10, 0);			// Set serial_in low

	#(100 * `per);
	serial_out(1, 1); 			  // set 1st bit to 1 = header
	serial_out(1, 0); 			  // set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `fe_disable_reg);	 // wr FE disable registers
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 8);			// Length
	serial_out(1, 0);						
	serial_out(1, 1);						
	serial_out(1, 0);						
	serial_out(1, 1);					
	serial_out(1, 0);		
	serial_out(1, 0);					
	serial_out(1, 1);					
	serial_out(1, 0);				
	serial_out(10, 0);					    // Set serial_in low

	#(100 * `per);
	serial_out(1, 1); 			// set 1st bit to 1 = header
	serial_out(1, 0); 			// set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `be_rdout_cntl);	// wr be_rdout_cntl	 
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 2);	// Length
	serial_out(1, 1);						
	serial_out(1, 1);						
	serial_out(10, 0);			// Set serial_in low

	#(12 * `per)	enable_apvmux = 1;

	#(100 * `per);
	serial_out(1, 1); 			  // set 1st bit to 1 = header
	serial_out(1, 1); 			  // set rd/wr ie: 1 is read and 0 is write
	serial_out(DESIGNATOR, `be_status_reg);	   // write to BE status register
	serial_out(1, 1); 
	serial_out(LENGTH_FIELD, 32);		// Length


end
endtask


endmodule
