-- hds header_start
--
-- VHDL Architecture back_end_fpga.total_len_flag_gen.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 13:38:39 03/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;

ENTITY total_len_flag_gen IS
   PORT( 
      clk2x                   : IN     std_logic;
      reset                   : IN     std_logic;
      total_length_fifo_flags : IN     std_logic_vector (2 DOWNTO 0);
      total_length_25_flag    : OUT    std_logic;
      total_length_50_flag    : OUT    std_logic;
      total_length_87_flag    : OUT    std_logic
   );

-- Declarations

END total_len_flag_gen ;

-- hds interface_end
ARCHITECTURE rtl OF total_len_flag_gen IS
BEGIN
Process (clk2x, reset)
	begin
	if reset = '1' then
		total_length_87_flag <= '0' after 1 ns;
		total_length_50_flag <= '0' after 1 ns;
		total_length_25_flag <= '0' after 1 ns;
	elsif clk2x'event AND clk2x = '1' then
		if conv_integer(total_length_fifo_flags) > 6 then  		-- 87% full
			total_length_87_flag <= '1' after 1 ns;
			total_length_50_flag <= '1' after 1 ns;
			total_length_25_flag <= '1' after 1 ns;
		elsif conv_integer(total_length_fifo_flags) > 3 then  		-- 50% full
			total_length_87_flag <= '0' after 1 ns;
			total_length_50_flag <= '1' after 1 ns;
			total_length_25_flag <= '1' after 1 ns;
		elsif conv_integer(total_length_fifo_flags) > 1 then  		-- 25% full
			total_length_87_flag <= '0' after 1 ns;
			total_length_50_flag <= '0' after 1 ns;
			total_length_25_flag <= '1' after 1 ns;
		else   										-- memory is not empty
			total_length_87_flag <= '0' after 1 ns;
			total_length_50_flag <= '0' after 1 ns;
			total_length_25_flag <= '0' after 1 ns;
		end if;
	end if;	
end process;
END rtl;
