-- hds header_start
--
-- VHDL Architecture back_end_fpga.trkr_hdr_flag_gen.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2MALDIVES)
--          at - 13:59:10 03/18/04
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY trkr_hdr_flag_gen IS
   PORT( 
      clk2x               : IN     std_logic;
      reset               : IN     std_logic;
      trkr_hdr_fifo_flags : IN     std_logic_vector (2 DOWNTO 0);
      trkr_hdr_25_flag    : OUT    std_logic;
      trkr_hdr_50_flag    : OUT    std_logic;
      trkr_hdr_87_flag    : OUT    std_logic
   );

-- Declarations

END trkr_hdr_flag_gen ;

-- hds interface_end
ARCHITECTURE rtl OF trkr_hdr_flag_gen IS
BEGIN
Process (clk2x, reset)
	begin
	if reset = '1' then
		trkr_hdr_87_flag <= '0' after 1 ns;
		trkr_hdr_50_flag <= '0' after 1 ns;
		trkr_hdr_25_flag <= '0' after 1 ns;
	elsif clk2x'event AND clk2x = '1' then
		if conv_integer(trkr_hdr_fifo_flags) > 6 then  		-- 87% full
			trkr_hdr_87_flag <= '1' after 1 ns;
			trkr_hdr_50_flag <= '1' after 1 ns;
			trkr_hdr_25_flag <= '1' after 1 ns;
		elsif conv_integer(trkr_hdr_fifo_flags) > 3 then  		-- 50% full
			trkr_hdr_87_flag <= '0' after 1 ns;
			trkr_hdr_50_flag <= '1' after 1 ns;
			trkr_hdr_25_flag <= '1' after 1 ns;
		elsif conv_integer(trkr_hdr_fifo_flags) > 1 then  		-- 25% full
			trkr_hdr_87_flag <= '0' after 1 ns;
			trkr_hdr_50_flag <= '0' after 1 ns;
			trkr_hdr_25_flag <= '1' after 1 ns;
		else   										-- memory is not empty
			trkr_hdr_87_flag <= '0' after 1 ns;
			trkr_hdr_50_flag <= '0' after 1 ns;
			trkr_hdr_25_flag <= '0' after 1 ns;
		end if;
	end if;	
end process;
END rtl;
