-- hds header_start
--
-- VHDL Architecture back_end_fpga.tst_fe_data_block.testshell
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 11:38:56 07/14/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1b (Build 7)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;

ENTITY tst_fe_data_block IS
   PORT( 
      FE_lvds_clk         : IN     std_logic_vector (8 DOWNTO 1);
      FE_lvds_clk_B       : IN     std_logic_vector (8 DOWNTO 1);
      fe_config_in        : IN     std_logic_vector (8 DOWNTO 1);
      fe_frame_sync_in    : IN     std_logic_vector (8 DOWNTO 1);
      fe_monitor_in       : IN     std_logic_vector (8 DOWNTO 1);
      fe_readout_sync_in  : IN     std_logic_vector (8 DOWNTO 1);
      iclk_1x             : IN     std_logic;
      rst                 : IN     std_logic;
      fe_config_out       : OUT    std_logic_vector (8 DOWNTO 1);
      fe_frame_sync_out   : OUT    std_logic_vector (8 DOWNTO 1);
      fe_monitor_out      : OUT    std_logic_vector (8 DOWNTO 1);
      fe_readout_sync_out : OUT    std_logic_vector (8 DOWNTO 1);
      mod1_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod2_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod3_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod4_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod5_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod6_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod7_data           : OUT    std_logic_vector (3 DOWNTO 0);
      mod8_data           : OUT    std_logic_vector (3 DOWNTO 0);
      clk                 : INOUT  std_logic
   );

-- Declarations

END tst_fe_data_block ;

-- hds interface_end
ARCHITECTURE testshell OF tst_fe_data_block IS
BEGIN

clk_gen : process
	begin
 		clk <= '0';
 	    wait for 12.5 ns;
		clk <= '1';
		wait for 12.5 ns;
end process clk_gen;



fe : process(fe_monitor_in(1),clk)
  variable state, count, delay : integer := 0;
  variable length : std_logic_vector(16 downto 0) := (15 =>'1', 4 => '1', others => '0');
  begin
    if (fe_monitor_in(1)='1') then
      state:=0;
      count:=0;
      delay:=0;
      fe_config_out<="00000000";
      fe_frame_sync_out<="00000000";
      fe_monitor_out<="00000000";
      fe_readout_sync_out<="00000000";
	  mod1_data <= (others => '0');
	  mod2_data <= (others => '0');
	  mod3_data <= (others => '0');
	  mod4_data <= (others => '0');
	  mod5_data <= (others => '0');
	  mod6_data <= (others => '0');
	  mod7_data <= (others => '0');
	  mod8_data <= (others => '0');
    else
      if (clk'event and clk='0') then
        if (delay<=125) then
          delay:=delay+1;
          state:=17;
        elsif (delay=126) then
          state:=0;
          delay:=127;
        end if;  
        if (state=0) then
          fe_frame_sync_out <= "11111111";
          state:=state+1;
        elsif (state=1) then
          fe_frame_sync_out <= "00000000";
          state:=state+1;
        elsif (state>0 and state<16) then
          state:=state+1;
        elsif (state=16) then
          if (count <=16) then
            fe_readout_sync_out <= (others => length(count));
            count:=count+1;
          else
            count:=0;
            state:=17;
          end if;
        elsif (state=17) then
        state:=17;
      end if;    
     end if;
    end if;   
  end process;

END testshell;
