-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.add_one.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 16:04:50 10/17/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY wr_add_one IS
   PORT( 
      clk2x             : IN     std_logic;
      reset             : IN     std_logic;
      store_frame_data8 : IN     std_logic;
      wr_base_8         : IN     std_logic_VECTOR (17 DOWNTO 0);
      wr_base_increment : OUT    std_logic_VECTOR (17 DOWNTO 0)
   );

-- Declarations

END wr_add_one ;

-- hds interface_end
ARCHITECTURE rtl OF wr_add_one IS
BEGIN

	process (reset , clk2x)
		variable addr_temp : unsigned (17 downto 0);
	begin
		if reset = '1' then
			addr_temp := (others => '0');
		elsif clk2x'event AND clk2x = '1' then
			if store_frame_data8 = '1' then			-- if addr count is enabled then
				addr_temp :=  unsigned(wr_base_8);	
				addr_temp := addr_temp + 1;			-- increase addr by 1
			else
				addr_temp := (others => '0');		-- output zero to addr bus
			end if;
		end if;
	wr_base_increment <= std_logic_vector (addr_temp) after 1 ns;
	end process;
END rtl;
