-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.addr_mux.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 15:02:30 10/17/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY wr_addr_mux IS
   PORT( 
      clk2x             : IN     std_logic;
      load_or_count     : IN     std_logic;
      reset             : IN     std_logic;
      wr_base_1         : IN     std_logic_VECTOR (17 DOWNTO 0);
      wr_base_increment : IN     std_logic_VECTOR (17 DOWNTO 0);
      wr_base_2         : OUT    std_logic_VECTOR (17 DOWNTO 0)
   );

-- Declarations

END wr_addr_mux ;

-- hds interface_end
ARCHITECTURE rtl OF wr_addr_mux IS
BEGIN
	process (reset, clk2x)
		variable wr_flag : std_logic_VECTOR (17 DOWNTO 0);
	begin
		if reset = '1' then
			wr_flag := (others => '0');
		elsif clk2x'event AND clk2x='1' then
			if load_or_count = '1' then			-- if in load mode
				wr_flag := wr_base_1;			-- then let base address be loaded
			else								-- if in count mode
				wr_flag := wr_base_increment;	-- load the wrapper address from end of shift register
			end if;
		end if;
	wr_base_2 <= wr_flag after 1 ns;
	end process;
END rtl;
