-- hds header_start
--
-- VHDL Architecture cms_fed_be_fpga.decrement_one.rtl
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 16:36:00 10/17/02
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY wr_decrement_one IS
   PORT( 
      addr_count_en1   : IN     std_logic;
      clk2x            : IN     std_logic;
      load_or_count_1  : IN     std_logic;
      reset            : IN     std_logic;
      wr_length_8      : IN     std_logic_VECTOR (17 DOWNTO 0);
      length_decrement : OUT    std_logic_VECTOR (17 DOWNTO 0);
      store_frame_data : OUT    std_logic
   );

-- Declarations

END wr_decrement_one ;

-- hds interface_end
ARCHITECTURE rtl OF wr_decrement_one IS
BEGIN
	process (reset, clk2x)
		variable length_temp : unsigned (17 downto 0);
		variable frame_flag : std_logic;
	begin
		if reset = '1' then
			length_temp := (others => '0');
			frame_flag := '0';
		elsif clk2x'event AND clk2x = '1' then
			if load_or_count_1 = '1' then					-- if in load mode
				length_temp := (others => '0');				-- put address zero out
				frame_flag := '1';							-- set store data flag to '1' for data to be written to QDR.
			else											-- if in count mode
				if addr_count_en1 = '1' then				-- and operation is enabled
					length_temp := unsigned(wr_length_8);	-- then work out new length
					if length_temp = 1 then					-- if length is one, then this is last data so stop storing.
						frame_flag := '0';					-- all data has been stored
						length_temp := (others => '0');		--  push out length zero onto shift register
					else									-- if length is not zero, then store data
						length_temp := length_temp - 1;		-- and decrement the length by one 
						frame_flag := '1';					-- '1' means store data, as there is still data to be written to QDR.
					end if;
				end if;
			end if;
		end if;
	wr_length_3 <= std_logic_vector (length_temp) after 1 ns;	 -- push out new length onto shift register
	store_frame_data <= frame_flag after 1 ns;
	end process;
END rtl;
