-- hds header_start
--
-- VHDL Architecture back_end_fpga.wr_decrement_one.rtl_1
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 14:21:58 03/13/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY wr_decrement_one IS
   PORT( 
      clk2x             : IN     std_logic;
      reset             : IN     std_logic;
      wr_length_8       : IN     std_logic_VECTOR (17 DOWNTO 0);
      length_decrement  : OUT    std_logic_VECTOR (17 DOWNTO 0);
      store_frame_data1 : OUT    std_logic;
      store_frame_data8 : IN     std_logic
   );

-- Declarations

END wr_decrement_one ;

-- hds interface_end
ARCHITECTURE rtl_1 OF wr_decrement_one IS
BEGIN
	process (reset, clk2x)
		variable length_temp : unsigned (17 downto 0);
		variable frame_flag : std_logic;
	begin
	if reset = '1' then
		length_temp := (others => '0');
		frame_flag := '0';
	elsif clk2x'event AND clk2x = '1' then
		if store_frame_data8 = '1' then				-- if operation is enabled
			length_temp := unsigned(wr_length_8);	-- then work out new length
			if length_temp = 1 then					-- if length is one, then this is last data so stop storing.
				frame_flag := '0';					-- all data has been stored
				length_temp := (others => '0');		-- push out length zero onto shift register
			else									-- if length is not zero, then store data
				length_temp := length_temp - 1;		-- and decrement the length by one 
				frame_flag := '1';					-- '1' means store data, as there is still data to be written to QDR.
			end if;
		else										-- if operation is not enabled
			length_temp := (others => '0');		    -- output zeros for length
			frame_flag := '0';						-- set write flag to zero to disable writing to QDR
		end if;
	end if;
	length_decrement <= std_logic_vector (length_temp) after 1 ns;	 -- push out new length onto shift register
	store_frame_data1 <= frame_flag after 1 ns;
	end process;

END rtl_1;
