-- hds header_start
--
-- VHDL Architecture back_end_fpga.wr_length_mux.rtl_1
--
-- Created:
--          by - st79.UNKNOWN (TE2BELIZE)
--          at - 10:58:16 03/13/03
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2002.1a (Build 22)
--
-- hds header_end
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY wr_length_mux IS
   PORT( 
      clk2x             : IN     std_logic;
      length_decrement  : IN     std_logic_VECTOR (17 DOWNTO 0);
      load_or_count     : IN     std_logic;
      reset             : IN     std_logic;
      store_frame_data1 : IN     std_logic;
      wr_length_1       : IN     std_logic_vector (17 DOWNTO 0);
      store_frame_data2 : OUT    std_logic;
      wr_length_2       : OUT    std_logic_vector (17 DOWNTO 0)
   );

-- Declarations

END wr_length_mux ;

-- hds interface_end
ARCHITECTURE rtl OF wr_length_mux IS
BEGIN
	process (reset, clk2x)
		variable wr_flag : std_logic_vector (17 DOWNTO 0);
		variable frame_flag : std_logic;
	begin
		if reset = '1' then
			wr_flag := (others => '0');
			frame_flag := '0';
		else
			if clk2x'event AND clk2x='1' then
				if load_or_count = '1' then				-- if in load mode
					wr_flag := wr_length_1;				-- then let length data be loaded
					frame_flag := '1';					-- set write to QDR flag to '1'
				else									-- if in count mode
					wr_flag := length_decrement;		-- then load the wrapper length from end of shift register
					frame_flag := store_frame_data1;	-- let the write to QDR flag from decrement block go through to output
				end if;
			end if;
		end if;
	wr_length_2 <= wr_flag after 1 ns;
	store_frame_data2 <= frame_flag after 1 ns;
	end process;
END rtl;
